/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCommitResponse extends CodeCommitResponse implements
        ToCopyableBuilder<CreateCommitResponse.Builder, CreateCommitResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitId").getter(getter(CreateCommitResponse::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> TREE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("treeId")
            .getter(getter(CreateCommitResponse::treeId)).setter(setter(Builder::treeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()).build();

    private static final SdkField<List<FileMetadata>> FILES_ADDED_FIELD = SdkField
            .<List<FileMetadata>> builder(MarshallingType.LIST)
            .memberName("filesAdded")
            .getter(getter(CreateCommitResponse::filesAdded))
            .setter(setter(Builder::filesAdded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesAdded").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FileMetadata>> FILES_UPDATED_FIELD = SdkField
            .<List<FileMetadata>> builder(MarshallingType.LIST)
            .memberName("filesUpdated")
            .getter(getter(CreateCommitResponse::filesUpdated))
            .setter(setter(Builder::filesUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesUpdated").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FileMetadata>> FILES_DELETED_FIELD = SdkField
            .<List<FileMetadata>> builder(MarshallingType.LIST)
            .memberName("filesDeleted")
            .getter(getter(CreateCommitResponse::filesDeleted))
            .setter(setter(Builder::filesDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesDeleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD,
            TREE_ID_FIELD, FILES_ADDED_FIELD, FILES_UPDATED_FIELD, FILES_DELETED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String commitId;

    private final String treeId;

    private final List<FileMetadata> filesAdded;

    private final List<FileMetadata> filesUpdated;

    private final List<FileMetadata> filesDeleted;

    private CreateCommitResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.treeId = builder.treeId;
        this.filesAdded = builder.filesAdded;
        this.filesUpdated = builder.filesUpdated;
        this.filesDeleted = builder.filesDeleted;
    }

    /**
     * <p>
     * The full commit ID of the commit that contains your committed file changes.
     * </p>
     * 
     * @return The full commit ID of the commit that contains your committed file changes.
     */
    public final String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.
     * </p>
     * 
     * @return The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.
     */
    public final String treeId() {
        return treeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilesAdded property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilesAdded() {
        return filesAdded != null && !(filesAdded instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The files added as part of the committed file changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilesAdded} method.
     * </p>
     * 
     * @return The files added as part of the committed file changes.
     */
    public final List<FileMetadata> filesAdded() {
        return filesAdded;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilesUpdated property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilesUpdated() {
        return filesUpdated != null && !(filesUpdated instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The files updated as part of the commited file changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilesUpdated} method.
     * </p>
     * 
     * @return The files updated as part of the commited file changes.
     */
    public final List<FileMetadata> filesUpdated() {
        return filesUpdated;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilesDeleted property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilesDeleted() {
        return filesDeleted != null && !(filesDeleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The files deleted as part of the committed file changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilesDeleted} method.
     * </p>
     * 
     * @return The files deleted as part of the committed file changes.
     */
    public final List<FileMetadata> filesDeleted() {
        return filesDeleted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(treeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilesAdded() ? filesAdded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilesUpdated() ? filesUpdated() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilesDeleted() ? filesDeleted() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommitResponse)) {
            return false;
        }
        CreateCommitResponse other = (CreateCommitResponse) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(treeId(), other.treeId())
                && hasFilesAdded() == other.hasFilesAdded() && Objects.equals(filesAdded(), other.filesAdded())
                && hasFilesUpdated() == other.hasFilesUpdated() && Objects.equals(filesUpdated(), other.filesUpdated())
                && hasFilesDeleted() == other.hasFilesDeleted() && Objects.equals(filesDeleted(), other.filesDeleted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCommitResponse").add("CommitId", commitId()).add("TreeId", treeId())
                .add("FilesAdded", hasFilesAdded() ? filesAdded() : null)
                .add("FilesUpdated", hasFilesUpdated() ? filesUpdated() : null)
                .add("FilesDeleted", hasFilesDeleted() ? filesDeleted() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "treeId":
            return Optional.ofNullable(clazz.cast(treeId()));
        case "filesAdded":
            return Optional.ofNullable(clazz.cast(filesAdded()));
        case "filesUpdated":
            return Optional.ofNullable(clazz.cast(filesUpdated()));
        case "filesDeleted":
            return Optional.ofNullable(clazz.cast(filesDeleted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commitId", COMMIT_ID_FIELD);
        map.put("treeId", TREE_ID_FIELD);
        map.put("filesAdded", FILES_ADDED_FIELD);
        map.put("filesUpdated", FILES_UPDATED_FIELD);
        map.put("filesDeleted", FILES_DELETED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCommitResponse, T> g) {
        return obj -> g.apply((CreateCommitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCommitResponse> {
        /**
         * <p>
         * The full commit ID of the commit that contains your committed file changes.
         * </p>
         * 
         * @param commitId
         *        The full commit ID of the commit that contains your committed file changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.
         * </p>
         * 
         * @param treeId
         *        The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeId(String treeId);

        /**
         * <p>
         * The files added as part of the committed file changes.
         * </p>
         * 
         * @param filesAdded
         *        The files added as part of the committed file changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesAdded(Collection<FileMetadata> filesAdded);

        /**
         * <p>
         * The files added as part of the committed file changes.
         * </p>
         * 
         * @param filesAdded
         *        The files added as part of the committed file changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesAdded(FileMetadata... filesAdded);

        /**
         * <p>
         * The files added as part of the committed file changes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.FileMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #filesAdded(List<FileMetadata>)}.
         * 
         * @param filesAdded
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filesAdded(java.util.Collection<FileMetadata>)
         */
        Builder filesAdded(Consumer<FileMetadata.Builder>... filesAdded);

        /**
         * <p>
         * The files updated as part of the commited file changes.
         * </p>
         * 
         * @param filesUpdated
         *        The files updated as part of the commited file changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesUpdated(Collection<FileMetadata> filesUpdated);

        /**
         * <p>
         * The files updated as part of the commited file changes.
         * </p>
         * 
         * @param filesUpdated
         *        The files updated as part of the commited file changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesUpdated(FileMetadata... filesUpdated);

        /**
         * <p>
         * The files updated as part of the commited file changes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.FileMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #filesUpdated(List<FileMetadata>)}.
         * 
         * @param filesUpdated
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filesUpdated(java.util.Collection<FileMetadata>)
         */
        Builder filesUpdated(Consumer<FileMetadata.Builder>... filesUpdated);

        /**
         * <p>
         * The files deleted as part of the committed file changes.
         * </p>
         * 
         * @param filesDeleted
         *        The files deleted as part of the committed file changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesDeleted(Collection<FileMetadata> filesDeleted);

        /**
         * <p>
         * The files deleted as part of the committed file changes.
         * </p>
         * 
         * @param filesDeleted
         *        The files deleted as part of the committed file changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesDeleted(FileMetadata... filesDeleted);

        /**
         * <p>
         * The files deleted as part of the committed file changes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.FileMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #filesDeleted(List<FileMetadata>)}.
         * 
         * @param filesDeleted
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.FileMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filesDeleted(java.util.Collection<FileMetadata>)
         */
        Builder filesDeleted(Consumer<FileMetadata.Builder>... filesDeleted);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String commitId;

        private String treeId;

        private List<FileMetadata> filesAdded = DefaultSdkAutoConstructList.getInstance();

        private List<FileMetadata> filesUpdated = DefaultSdkAutoConstructList.getInstance();

        private List<FileMetadata> filesDeleted = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommitResponse model) {
            super(model);
            commitId(model.commitId);
            treeId(model.treeId);
            filesAdded(model.filesAdded);
            filesUpdated(model.filesUpdated);
            filesDeleted(model.filesDeleted);
        }

        public final String getCommitId() {
            return commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getTreeId() {
            return treeId;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final List<FileMetadata.Builder> getFilesAdded() {
            List<FileMetadata.Builder> result = FilesMetadataCopier.copyToBuilder(this.filesAdded);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilesAdded(Collection<FileMetadata.BuilderImpl> filesAdded) {
            this.filesAdded = FilesMetadataCopier.copyFromBuilder(filesAdded);
        }

        @Override
        public final Builder filesAdded(Collection<FileMetadata> filesAdded) {
            this.filesAdded = FilesMetadataCopier.copy(filesAdded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesAdded(FileMetadata... filesAdded) {
            filesAdded(Arrays.asList(filesAdded));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesAdded(Consumer<FileMetadata.Builder>... filesAdded) {
            filesAdded(Stream.of(filesAdded).map(c -> FileMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FileMetadata.Builder> getFilesUpdated() {
            List<FileMetadata.Builder> result = FilesMetadataCopier.copyToBuilder(this.filesUpdated);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilesUpdated(Collection<FileMetadata.BuilderImpl> filesUpdated) {
            this.filesUpdated = FilesMetadataCopier.copyFromBuilder(filesUpdated);
        }

        @Override
        public final Builder filesUpdated(Collection<FileMetadata> filesUpdated) {
            this.filesUpdated = FilesMetadataCopier.copy(filesUpdated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesUpdated(FileMetadata... filesUpdated) {
            filesUpdated(Arrays.asList(filesUpdated));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesUpdated(Consumer<FileMetadata.Builder>... filesUpdated) {
            filesUpdated(Stream.of(filesUpdated).map(c -> FileMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FileMetadata.Builder> getFilesDeleted() {
            List<FileMetadata.Builder> result = FilesMetadataCopier.copyToBuilder(this.filesDeleted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilesDeleted(Collection<FileMetadata.BuilderImpl> filesDeleted) {
            this.filesDeleted = FilesMetadataCopier.copyFromBuilder(filesDeleted);
        }

        @Override
        public final Builder filesDeleted(Collection<FileMetadata> filesDeleted) {
            this.filesDeleted = FilesMetadataCopier.copy(filesDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesDeleted(FileMetadata... filesDeleted) {
            filesDeleted(Arrays.asList(filesDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesDeleted(Consumer<FileMetadata.Builder>... filesDeleted) {
            filesDeleted(Stream.of(filesDeleted).map(c -> FileMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateCommitResponse build() {
            return new CreateCommitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
