/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRepositoryDescriptionRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, UpdateRepositoryDescriptionRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(UpdateRepositoryDescriptionRequest.getter(UpdateRepositoryDescriptionRequest::repositoryName)).setter(UpdateRepositoryDescriptionRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> REPOSITORY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryDescription").getter(UpdateRepositoryDescriptionRequest.getter(UpdateRepositoryDescriptionRequest::repositoryDescription)).setter(UpdateRepositoryDescriptionRequest.setter(Builder::repositoryDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, REPOSITORY_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("repositoryName", REPOSITORY_NAME_FIELD);
            this.put("repositoryDescription", REPOSITORY_DESCRIPTION_FIELD);
        }
    });
    private final String repositoryName;
    private final String repositoryDescription;

    private UpdateRepositoryDescriptionRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.repositoryDescription = builder.repositoryDescription;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String repositoryDescription() {
        return this.repositoryDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryDescriptionRequest)) {
            return false;
        }
        UpdateRepositoryDescriptionRequest other = (UpdateRepositoryDescriptionRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.repositoryDescription(), other.repositoryDescription());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRepositoryDescriptionRequest").add("RepositoryName", (Object)this.repositoryName()).add("RepositoryDescription", (Object)this.repositoryDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "repositoryDescription": {
                return Optional.ofNullable(clazz.cast(this.repositoryDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryDescriptionRequest, T> g) {
        return obj -> g.apply((UpdateRepositoryDescriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String repositoryDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryDescriptionRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.repositoryDescription(model.repositoryDescription);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryDescription() {
            return this.repositoryDescription;
        }

        public final void setRepositoryDescription(String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
        }

        @Override
        public final Builder repositoryDescription(String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRepositoryDescriptionRequest build() {
            return new UpdateRepositoryDescriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRepositoryDescriptionRequest> {
        public Builder repositoryName(String var1);

        public Builder repositoryDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

