/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCommentsForComparedCommitRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, GetCommentsForComparedCommitRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(GetCommentsForComparedCommitRequest.getter(GetCommentsForComparedCommitRequest::repositoryName)).setter(GetCommentsForComparedCommitRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("beforeCommitId").getter(GetCommentsForComparedCommitRequest.getter(GetCommentsForComparedCommitRequest::beforeCommitId)).setter(GetCommentsForComparedCommitRequest.setter(Builder::beforeCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()}).build();
    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterCommitId").getter(GetCommentsForComparedCommitRequest.getter(GetCommentsForComparedCommitRequest::afterCommitId)).setter(GetCommentsForComparedCommitRequest.setter(Builder::afterCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetCommentsForComparedCommitRequest.getter(GetCommentsForComparedCommitRequest::nextToken)).setter(GetCommentsForComparedCommitRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetCommentsForComparedCommitRequest.getter(GetCommentsForComparedCommitRequest::maxResults)).setter(GetCommentsForComparedCommitRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("repositoryName", REPOSITORY_NAME_FIELD);
            this.put("beforeCommitId", BEFORE_COMMIT_ID_FIELD);
            this.put("afterCommitId", AFTER_COMMIT_ID_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String repositoryName;
    private final String beforeCommitId;
    private final String afterCommitId;
    private final String nextToken;
    private final Integer maxResults;

    private GetCommentsForComparedCommitRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String beforeCommitId() {
        return this.beforeCommitId;
    }

    public final String afterCommitId() {
        return this.afterCommitId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommentsForComparedCommitRequest)) {
            return false;
        }
        GetCommentsForComparedCommitRequest other = (GetCommentsForComparedCommitRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.beforeCommitId(), other.beforeCommitId()) && Objects.equals(this.afterCommitId(), other.afterCommitId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetCommentsForComparedCommitRequest").add("RepositoryName", (Object)this.repositoryName()).add("BeforeCommitId", (Object)this.beforeCommitId()).add("AfterCommitId", (Object)this.afterCommitId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "beforeCommitId": {
                return Optional.ofNullable(clazz.cast(this.beforeCommitId()));
            }
            case "afterCommitId": {
                return Optional.ofNullable(clazz.cast(this.afterCommitId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCommentsForComparedCommitRequest, T> g) {
        return obj -> g.apply((GetCommentsForComparedCommitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String beforeCommitId;
        private String afterCommitId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommentsForComparedCommitRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.beforeCommitId(model.beforeCommitId);
            this.afterCommitId(model.afterCommitId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getBeforeCommitId() {
            return this.beforeCommitId;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final String getAfterCommitId() {
            return this.afterCommitId;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCommentsForComparedCommitRequest build() {
            return new GetCommentsForComparedCommitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCommentsForComparedCommitRequest> {
        public Builder repositoryName(String var1);

        public Builder beforeCommitId(String var1);

        public Builder afterCommitId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

