/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.OriginApprovalRuleTemplate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApprovalRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApprovalRule> {
    private static final SdkField<String> APPROVAL_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApprovalRule.getter(ApprovalRule::approvalRuleId)).setter(ApprovalRule.setter(Builder::approvalRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleId").build()}).build();
    private static final SdkField<String> APPROVAL_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApprovalRule.getter(ApprovalRule::approvalRuleName)).setter(ApprovalRule.setter(Builder::approvalRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleName").build()}).build();
    private static final SdkField<String> APPROVAL_RULE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApprovalRule.getter(ApprovalRule::approvalRuleContent)).setter(ApprovalRule.setter(Builder::approvalRuleContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleContent").build()}).build();
    private static final SdkField<String> RULE_CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApprovalRule.getter(ApprovalRule::ruleContentSha256)).setter(ApprovalRule.setter(Builder::ruleContentSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleContentSha256").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ApprovalRule.getter(ApprovalRule::lastModifiedDate)).setter(ApprovalRule.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ApprovalRule.getter(ApprovalRule::creationDate)).setter(ApprovalRule.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApprovalRule.getter(ApprovalRule::lastModifiedUser)).setter(ApprovalRule.setter(Builder::lastModifiedUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedUser").build()}).build();
    private static final SdkField<OriginApprovalRuleTemplate> ORIGIN_APPROVAL_RULE_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApprovalRule.getter(ApprovalRule::originApprovalRuleTemplate)).setter(ApprovalRule.setter(Builder::originApprovalRuleTemplate)).constructor(OriginApprovalRuleTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originApprovalRuleTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_RULE_ID_FIELD, APPROVAL_RULE_NAME_FIELD, APPROVAL_RULE_CONTENT_FIELD, RULE_CONTENT_SHA256_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_USER_FIELD, ORIGIN_APPROVAL_RULE_TEMPLATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String approvalRuleId;
    private final String approvalRuleName;
    private final String approvalRuleContent;
    private final String ruleContentSha256;
    private final Instant lastModifiedDate;
    private final Instant creationDate;
    private final String lastModifiedUser;
    private final OriginApprovalRuleTemplate originApprovalRuleTemplate;

    private ApprovalRule(BuilderImpl builder) {
        this.approvalRuleId = builder.approvalRuleId;
        this.approvalRuleName = builder.approvalRuleName;
        this.approvalRuleContent = builder.approvalRuleContent;
        this.ruleContentSha256 = builder.ruleContentSha256;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.originApprovalRuleTemplate = builder.originApprovalRuleTemplate;
    }

    public String approvalRuleId() {
        return this.approvalRuleId;
    }

    public String approvalRuleName() {
        return this.approvalRuleName;
    }

    public String approvalRuleContent() {
        return this.approvalRuleContent;
    }

    public String ruleContentSha256() {
        return this.ruleContentSha256;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String lastModifiedUser() {
        return this.lastModifiedUser;
    }

    public OriginApprovalRuleTemplate originApprovalRuleTemplate() {
        return this.originApprovalRuleTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.originApprovalRuleTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalRule)) {
            return false;
        }
        ApprovalRule other = (ApprovalRule)obj;
        return Objects.equals(this.approvalRuleId(), other.approvalRuleId()) && Objects.equals(this.approvalRuleName(), other.approvalRuleName()) && Objects.equals(this.approvalRuleContent(), other.approvalRuleContent()) && Objects.equals(this.ruleContentSha256(), other.ruleContentSha256()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedUser(), other.lastModifiedUser()) && Objects.equals(this.originApprovalRuleTemplate(), other.originApprovalRuleTemplate());
    }

    public String toString() {
        return ToString.builder((String)"ApprovalRule").add("ApprovalRuleId", (Object)this.approvalRuleId()).add("ApprovalRuleName", (Object)this.approvalRuleName()).add("ApprovalRuleContent", (Object)this.approvalRuleContent()).add("RuleContentSha256", (Object)this.ruleContentSha256()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedUser", (Object)this.lastModifiedUser()).add("OriginApprovalRuleTemplate", (Object)this.originApprovalRuleTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "approvalRuleId": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleId()));
            }
            case "approvalRuleName": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleName()));
            }
            case "approvalRuleContent": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleContent()));
            }
            case "ruleContentSha256": {
                return Optional.ofNullable(clazz.cast(this.ruleContentSha256()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedUser": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedUser()));
            }
            case "originApprovalRuleTemplate": {
                return Optional.ofNullable(clazz.cast(this.originApprovalRuleTemplate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApprovalRule, T> g) {
        return obj -> g.apply((ApprovalRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String approvalRuleId;
        private String approvalRuleName;
        private String approvalRuleContent;
        private String ruleContentSha256;
        private Instant lastModifiedDate;
        private Instant creationDate;
        private String lastModifiedUser;
        private OriginApprovalRuleTemplate originApprovalRuleTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalRule model) {
            this.approvalRuleId(model.approvalRuleId);
            this.approvalRuleName(model.approvalRuleName);
            this.approvalRuleContent(model.approvalRuleContent);
            this.ruleContentSha256(model.ruleContentSha256);
            this.lastModifiedDate(model.lastModifiedDate);
            this.creationDate(model.creationDate);
            this.lastModifiedUser(model.lastModifiedUser);
            this.originApprovalRuleTemplate(model.originApprovalRuleTemplate);
        }

        public final String getApprovalRuleId() {
            return this.approvalRuleId;
        }

        @Override
        public final Builder approvalRuleId(String approvalRuleId) {
            this.approvalRuleId = approvalRuleId;
            return this;
        }

        public final void setApprovalRuleId(String approvalRuleId) {
            this.approvalRuleId = approvalRuleId;
        }

        public final String getApprovalRuleName() {
            return this.approvalRuleName;
        }

        @Override
        public final Builder approvalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
            return this;
        }

        public final void setApprovalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
        }

        public final String getApprovalRuleContent() {
            return this.approvalRuleContent;
        }

        @Override
        public final Builder approvalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
            return this;
        }

        public final void setApprovalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
        }

        public final String getRuleContentSha256() {
            return this.ruleContentSha256;
        }

        @Override
        public final Builder ruleContentSha256(String ruleContentSha256) {
            this.ruleContentSha256 = ruleContentSha256;
            return this;
        }

        public final void setRuleContentSha256(String ruleContentSha256) {
            this.ruleContentSha256 = ruleContentSha256;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public final OriginApprovalRuleTemplate.Builder getOriginApprovalRuleTemplate() {
            return this.originApprovalRuleTemplate != null ? this.originApprovalRuleTemplate.toBuilder() : null;
        }

        @Override
        public final Builder originApprovalRuleTemplate(OriginApprovalRuleTemplate originApprovalRuleTemplate) {
            this.originApprovalRuleTemplate = originApprovalRuleTemplate;
            return this;
        }

        public final void setOriginApprovalRuleTemplate(OriginApprovalRuleTemplate.BuilderImpl originApprovalRuleTemplate) {
            this.originApprovalRuleTemplate = originApprovalRuleTemplate != null ? originApprovalRuleTemplate.build() : null;
        }

        public ApprovalRule build() {
            return new ApprovalRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApprovalRule> {
        public Builder approvalRuleId(String var1);

        public Builder approvalRuleName(String var1);

        public Builder approvalRuleContent(String var1);

        public Builder ruleContentSha256(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedUser(String var1);

        public Builder originApprovalRuleTemplate(OriginApprovalRuleTemplate var1);

        default public Builder originApprovalRuleTemplate(Consumer<OriginApprovalRuleTemplate.Builder> originApprovalRuleTemplate) {
            return this.originApprovalRuleTemplate((OriginApprovalRuleTemplate)((OriginApprovalRuleTemplate.Builder)OriginApprovalRuleTemplate.builder().applyMutation(originApprovalRuleTemplate)).build());
        }
    }
}

