/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePullRequestDescriptionResponse extends CodeCommitResponse implements
        ToCopyableBuilder<UpdatePullRequestDescriptionResponse.Builder, UpdatePullRequestDescriptionResponse> {
    private static final SdkField<PullRequest> PULL_REQUEST_FIELD = SdkField.<PullRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdatePullRequestDescriptionResponse::pullRequest)).setter(setter(Builder::pullRequest))
            .constructor(PullRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_FIELD));

    private final PullRequest pullRequest;

    private UpdatePullRequestDescriptionResponse(BuilderImpl builder) {
        super(builder);
        this.pullRequest = builder.pullRequest;
    }

    /**
     * <p>
     * Information about the updated pull request.
     * </p>
     * 
     * @return Information about the updated pull request.
     */
    public PullRequest pullRequest() {
        return pullRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePullRequestDescriptionResponse)) {
            return false;
        }
        UpdatePullRequestDescriptionResponse other = (UpdatePullRequestDescriptionResponse) obj;
        return Objects.equals(pullRequest(), other.pullRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdatePullRequestDescriptionResponse").add("PullRequest", pullRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequest":
            return Optional.ofNullable(clazz.cast(pullRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePullRequestDescriptionResponse, T> g) {
        return obj -> g.apply((UpdatePullRequestDescriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePullRequestDescriptionResponse> {
        /**
         * <p>
         * Information about the updated pull request.
         * </p>
         * 
         * @param pullRequest
         *        Information about the updated pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequest(PullRequest pullRequest);

        /**
         * <p>
         * Information about the updated pull request.
         * </p>
         * This is a convenience that creates an instance of the {@link PullRequest.Builder} avoiding the need to create
         * one manually via {@link PullRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link PullRequest.Builder#build()} is called immediately and its result
         * is passed to {@link #pullRequest(PullRequest)}.
         * 
         * @param pullRequest
         *        a consumer that will call methods on {@link PullRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pullRequest(PullRequest)
         */
        default Builder pullRequest(Consumer<PullRequest.Builder> pullRequest) {
            return pullRequest(PullRequest.builder().applyMutation(pullRequest).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private PullRequest pullRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePullRequestDescriptionResponse model) {
            super(model);
            pullRequest(model.pullRequest);
        }

        public final PullRequest.Builder getPullRequest() {
            return pullRequest != null ? pullRequest.toBuilder() : null;
        }

        @Override
        public final Builder pullRequest(PullRequest pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        public final void setPullRequest(PullRequest.BuilderImpl pullRequest) {
            this.pullRequest = pullRequest != null ? pullRequest.build() : null;
        }

        @Override
        public UpdatePullRequestDescriptionResponse build() {
            return new UpdatePullRequestDescriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
