/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystResponse;
import software.amazon.awssdk.services.codecatalyst.model.WorkflowRunSummariesCopier;
import software.amazon.awssdk.services.codecatalyst.model.WorkflowRunSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowRunsResponse
extends CodeCatalystResponse
implements ToCopyableBuilder<Builder, ListWorkflowRunsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkflowRunsResponse.getter(ListWorkflowRunsResponse::nextToken)).setter(ListWorkflowRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<WorkflowRunSummary>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(ListWorkflowRunsResponse.getter(ListWorkflowRunsResponse::items)).setter(ListWorkflowRunsResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowRunSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkflowRunsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<WorkflowRunSummary> items;

    private ListWorkflowRunsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.items = builder.items;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<WorkflowRunSummary> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowRunsResponse)) {
            return false;
        }
        ListWorkflowRunsResponse other = (ListWorkflowRunsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowRunsResponse").add("NextToken", (Object)this.nextToken()).add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("items", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowRunsResponse, T> g) {
        return obj -> g.apply((ListWorkflowRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkflowRunSummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowRunsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.items(model.items);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkflowRunSummary.Builder> getItems() {
            List<WorkflowRunSummary.Builder> result = WorkflowRunSummariesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<WorkflowRunSummary.BuilderImpl> items) {
            this.items = WorkflowRunSummariesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<WorkflowRunSummary> items) {
            this.items = WorkflowRunSummariesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(WorkflowRunSummary ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<WorkflowRunSummary.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (WorkflowRunSummary)((WorkflowRunSummary.Builder)WorkflowRunSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkflowRunsResponse build() {
            return new ListWorkflowRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCatalystResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowRunsResponse> {
        public Builder nextToken(String var1);

        public Builder items(Collection<WorkflowRunSummary> var1);

        public Builder items(WorkflowRunSummary ... var1);

        public Builder items(Consumer<WorkflowRunSummary.Builder> ... var1);
    }
}

