/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystRequest;
import software.amazon.awssdk.services.codecatalyst.model.WorkflowSortCriteria;
import software.amazon.awssdk.services.codecatalyst.model.WorkflowSortCriteriaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowsRequest
extends CodeCatalystRequest
implements ToCopyableBuilder<Builder, ListWorkflowsRequest> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::spaceName)).setter(ListWorkflowsRequest.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::projectName)).setter(ListWorkflowsRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::nextToken)).setter(ListWorkflowsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::maxResults)).setter(ListWorkflowsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<List<WorkflowSortCriteria>> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sortBy").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::sortBy)).setter(ListWorkflowsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowSortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("spaceName", SPACE_NAME_FIELD);
            this.put("projectName", PROJECT_NAME_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("sortBy", SORT_BY_FIELD);
        }
    });
    private final String spaceName;
    private final String projectName;
    private final String nextToken;
    private final Integer maxResults;
    private final List<WorkflowSortCriteria> sortBy;

    private ListWorkflowsRequest(BuilderImpl builder) {
        super(builder);
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortBy = builder.sortBy;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasSortBy() {
        return this.sortBy != null && !(this.sortBy instanceof SdkAutoConstructList);
    }

    public final List<WorkflowSortCriteria> sortBy() {
        return this.sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortBy() ? this.sortBy() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowsRequest)) {
            return false;
        }
        ListWorkflowsRequest other = (ListWorkflowsRequest)((Object)obj);
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasSortBy() == other.hasSortBy() && Objects.equals(this.sortBy(), other.sortBy());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowsRequest").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SortBy", this.hasSortBy() ? this.sortBy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowsRequest, T> g) {
        return obj -> g.apply((ListWorkflowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystRequest.BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private String nextToken;
        private Integer maxResults;
        private List<WorkflowSortCriteria> sortBy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowsRequest model) {
            super(model);
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sortBy(model.sortBy);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<WorkflowSortCriteria.Builder> getSortBy() {
            List<WorkflowSortCriteria.Builder> result = WorkflowSortCriteriaListCopier.copyToBuilder(this.sortBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortBy(Collection<WorkflowSortCriteria.BuilderImpl> sortBy) {
            this.sortBy = WorkflowSortCriteriaListCopier.copyFromBuilder(sortBy);
        }

        @Override
        public final Builder sortBy(Collection<WorkflowSortCriteria> sortBy) {
            this.sortBy = WorkflowSortCriteriaListCopier.copy(sortBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(WorkflowSortCriteria ... sortBy) {
            this.sortBy(Arrays.asList(sortBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(Consumer<WorkflowSortCriteria.Builder> ... sortBy) {
            this.sortBy(Stream.of(sortBy).map(c -> (WorkflowSortCriteria)((WorkflowSortCriteria.Builder)WorkflowSortCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkflowsRequest build() {
            return new ListWorkflowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCatalystRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowsRequest> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortBy(Collection<WorkflowSortCriteria> var1);

        public Builder sortBy(WorkflowSortCriteria ... var1);

        public Builder sortBy(Consumer<WorkflowSortCriteria.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

