/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionSummary;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsResponse;

public class ListDevEnvironmentSessionsPublisher
implements SdkPublisher<ListDevEnvironmentSessionsResponse> {
    private final CodeCatalystAsyncClient client;
    private final ListDevEnvironmentSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevEnvironmentSessionsPublisher(CodeCatalystAsyncClient client, ListDevEnvironmentSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevEnvironmentSessionsPublisher(CodeCatalystAsyncClient client, ListDevEnvironmentSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevEnvironmentSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevEnvironmentSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DevEnvironmentSessionSummary> items() {
        Function<ListDevEnvironmentSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDevEnvironmentSessionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDevEnvironmentSessionsResponseFetcher
    implements AsyncPageFetcher<ListDevEnvironmentSessionsResponse> {
        private ListDevEnvironmentSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevEnvironmentSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevEnvironmentSessionsResponse> nextPage(ListDevEnvironmentSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListDevEnvironmentSessionsPublisher.this.client.listDevEnvironmentSessions(ListDevEnvironmentSessionsPublisher.this.firstRequest);
            }
            return ListDevEnvironmentSessionsPublisher.this.client.listDevEnvironmentSessions((ListDevEnvironmentSessionsRequest)((Object)ListDevEnvironmentSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

