/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessTokenRequest
extends CodeCatalystRequest
implements ToCopyableBuilder<Builder, CreateAccessTokenRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAccessTokenRequest.getter(CreateAccessTokenRequest::name)).setter(CreateAccessTokenRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> EXPIRES_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresTime").getter(CreateAccessTokenRequest.getter(CreateAccessTokenRequest::expiresTime)).setter(CreateAccessTokenRequest.setter(Builder::expiresTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EXPIRES_TIME_FIELD));
    private final String name;
    private final Instant expiresTime;

    private CreateAccessTokenRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.expiresTime = builder.expiresTime;
    }

    public final String name() {
        return this.name;
    }

    public final Instant expiresTime() {
        return this.expiresTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessTokenRequest)) {
            return false;
        }
        CreateAccessTokenRequest other = (CreateAccessTokenRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.expiresTime(), other.expiresTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessTokenRequest").add("Name", (Object)this.name()).add("ExpiresTime", (Object)this.expiresTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "expiresTime": {
                return Optional.ofNullable(clazz.cast(this.expiresTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessTokenRequest, T> g) {
        return obj -> g.apply((CreateAccessTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystRequest.BuilderImpl
    implements Builder {
        private String name;
        private Instant expiresTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessTokenRequest model) {
            super(model);
            this.name(model.name);
            this.expiresTime(model.expiresTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getExpiresTime() {
            return this.expiresTime;
        }

        public final void setExpiresTime(Instant expiresTime) {
            this.expiresTime = expiresTime;
        }

        @Override
        public final Builder expiresTime(Instant expiresTime) {
            this.expiresTime = expiresTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessTokenRequest build() {
            return new CreateAccessTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCatalystRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessTokenRequest> {
        public Builder name(String var1);

        public Builder expiresTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

