/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.CredentialType;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystServiceClientConfiguration;
import software.amazon.awssdk.services.codecatalyst.model.AccessDeniedException;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystException;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystRequest;
import software.amazon.awssdk.services.codecatalyst.model.ConflictException;
import software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse;
import software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.CreateProjectRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateProjectResponse;
import software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchResponse;
import software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenRequest;
import software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenResponse;
import software.amazon.awssdk.services.codecatalyst.model.DeleteDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.DeleteDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetProjectRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetProjectResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetSpaceRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetSpaceResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListProjectsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSpacesResponse;
import software.amazon.awssdk.services.codecatalyst.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codecatalyst.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionRequest;
import software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionResponse;
import software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionRequest;
import software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionResponse;
import software.amazon.awssdk.services.codecatalyst.model.ThrottlingException;
import software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.ValidationException;
import software.amazon.awssdk.services.codecatalyst.model.VerifySessionRequest;
import software.amazon.awssdk.services.codecatalyst.model.VerifySessionResponse;
import software.amazon.awssdk.services.codecatalyst.paginators.ListAccessTokensIterable;
import software.amazon.awssdk.services.codecatalyst.paginators.ListDevEnvironmentsIterable;
import software.amazon.awssdk.services.codecatalyst.paginators.ListEventLogsIterable;
import software.amazon.awssdk.services.codecatalyst.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.codecatalyst.paginators.ListSourceRepositoriesIterable;
import software.amazon.awssdk.services.codecatalyst.paginators.ListSourceRepositoryBranchesIterable;
import software.amazon.awssdk.services.codecatalyst.paginators.ListSpacesIterable;
import software.amazon.awssdk.services.codecatalyst.transform.CreateAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.CreateDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.CreateSourceRepositoryBranchRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.DeleteAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.DeleteDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetProjectRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetSourceRepositoryCloneUrlsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetSpaceRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetUserDetailsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListAccessTokensRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListDevEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListEventLogsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListSourceRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListSourceRepositoryBranchesRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListSpacesRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StartDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StartDevEnvironmentSessionRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StopDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StopDevEnvironmentSessionRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.UpdateDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.VerifySessionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCodeCatalystClient
implements CodeCatalystClient {
    private static final Logger log = Logger.loggerFor(DefaultCodeCatalystClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final CodeCatalystServiceClientConfiguration serviceClientConfiguration;

    protected DefaultCodeCatalystClient(CodeCatalystServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessTokenResponse createAccessToken(CreateAccessTokenRequest createAccessTokenRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccessTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, createAccessTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessToken");
            CreateAccessTokenResponse createAccessTokenResponse = (CreateAccessTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createAccessTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAccessTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAccessTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$createAccessToken$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDevEnvironmentResponse createDevEnvironment(CreateDevEnvironmentRequest createDevEnvironmentRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDevEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, createDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDevEnvironment");
            CreateDevEnvironmentResponse createDevEnvironmentResponse = (CreateDevEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDevEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createDevEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDevEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$createDevEnvironment$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, createProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProject");
            CreateProjectResponse createProjectResponse = (CreateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$createProject$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSourceRepositoryBranchResponse createSourceRepositoryBranch(CreateSourceRepositoryBranchRequest createSourceRepositoryBranchRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSourceRepositoryBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, createSourceRepositoryBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSourceRepositoryBranch");
            CreateSourceRepositoryBranchResponse createSourceRepositoryBranchResponse = (CreateSourceRepositoryBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSourceRepositoryBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createSourceRepositoryBranchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSourceRepositoryBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSourceRepositoryBranchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$createSourceRepositoryBranch$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessTokenResponse deleteAccessToken(DeleteAccessTokenRequest deleteAccessTokenRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccessTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessToken");
            DeleteAccessTokenResponse deleteAccessTokenResponse = (DeleteAccessTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)deleteAccessTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccessTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAccessTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$deleteAccessToken$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDevEnvironmentResponse deleteDevEnvironment(DeleteDevEnvironmentRequest deleteDevEnvironmentRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDevEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, deleteDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDevEnvironment");
            DeleteDevEnvironmentResponse deleteDevEnvironmentResponse = (DeleteDevEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDevEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)deleteDevEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDevEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$deleteDevEnvironment$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDevEnvironmentResponse getDevEnvironment(GetDevEnvironmentRequest getDevEnvironmentRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDevEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, getDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDevEnvironment");
            GetDevEnvironmentResponse getDevEnvironmentResponse = (GetDevEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getDevEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDevEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$getDevEnvironment$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetProjectResponse getProject(GetProjectRequest getProjectRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, getProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProject");
            GetProjectResponse getProjectResponse = (GetProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$getProject$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSourceRepositoryCloneUrlsResponse getSourceRepositoryCloneUrls(GetSourceRepositoryCloneUrlsRequest getSourceRepositoryCloneUrlsRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSourceRepositoryCloneUrlsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, getSourceRepositoryCloneUrlsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSourceRepositoryCloneUrls");
            GetSourceRepositoryCloneUrlsResponse getSourceRepositoryCloneUrlsResponse = (GetSourceRepositoryCloneUrlsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSourceRepositoryCloneUrls").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getSourceRepositoryCloneUrlsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSourceRepositoryCloneUrlsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSourceRepositoryCloneUrlsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$getSourceRepositoryCloneUrls$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSpaceResponse getSpace(GetSpaceRequest getSpaceRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSpaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, getSpaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSpace");
            GetSpaceResponse getSpaceResponse = (GetSpaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSpace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getSpaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSpaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSpaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$getSpace$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubscriptionResponse getSubscription(GetSubscriptionRequest getSubscriptionRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, getSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSubscription");
            GetSubscriptionResponse getSubscriptionResponse = (GetSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$getSubscription$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUserDetailsResponse getUserDetails(GetUserDetailsRequest getUserDetailsRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, getUserDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserDetails");
            GetUserDetailsResponse getUserDetailsResponse = (GetUserDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getUserDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUserDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUserDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$getUserDetails$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessTokensResponse listAccessTokens(ListAccessTokensRequest listAccessTokensRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccessTokensResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, listAccessTokensRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessTokens");
            ListAccessTokensResponse listAccessTokensResponse = (ListAccessTokensResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessTokens").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listAccessTokensRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccessTokensRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccessTokensResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$listAccessTokens$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccessTokensIterable listAccessTokensPaginator(ListAccessTokensRequest listAccessTokensRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        return new ListAccessTokensIterable(this, this.applyPaginatorUserAgent(listAccessTokensRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevEnvironmentsResponse listDevEnvironments(ListDevEnvironmentsRequest listDevEnvironmentsRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevEnvironmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, listDevEnvironmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevEnvironments");
            ListDevEnvironmentsResponse listDevEnvironmentsResponse = (ListDevEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevEnvironments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listDevEnvironmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevEnvironmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$listDevEnvironments$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDevEnvironmentsIterable listDevEnvironmentsPaginator(ListDevEnvironmentsRequest listDevEnvironmentsRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        return new ListDevEnvironmentsIterable(this, this.applyPaginatorUserAgent(listDevEnvironmentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventLogsResponse listEventLogs(ListEventLogsRequest listEventLogsRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventLogsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, listEventLogsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventLogs");
            ListEventLogsResponse listEventLogsResponse = (ListEventLogsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventLogs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listEventLogsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventLogsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventLogsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$listEventLogs$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEventLogsIterable listEventLogsPaginator(ListEventLogsRequest listEventLogsRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        return new ListEventLogsIterable(this, this.applyPaginatorUserAgent(listEventLogsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, listProjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProjects");
            ListProjectsResponse listProjectsResponse = (ListProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listProjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$listProjects$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        return new ListProjectsIterable(this, this.applyPaginatorUserAgent(listProjectsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSourceRepositoriesResponse listSourceRepositories(ListSourceRepositoriesRequest listSourceRepositoriesRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSourceRepositoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, listSourceRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSourceRepositories");
            ListSourceRepositoriesResponse listSourceRepositoriesResponse = (ListSourceRepositoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSourceRepositories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listSourceRepositoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSourceRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSourceRepositoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$listSourceRepositories$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSourceRepositoriesIterable listSourceRepositoriesPaginator(ListSourceRepositoriesRequest listSourceRepositoriesRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        return new ListSourceRepositoriesIterable(this, this.applyPaginatorUserAgent(listSourceRepositoriesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSourceRepositoryBranchesResponse listSourceRepositoryBranches(ListSourceRepositoryBranchesRequest listSourceRepositoryBranchesRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSourceRepositoryBranchesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, listSourceRepositoryBranchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSourceRepositoryBranches");
            ListSourceRepositoryBranchesResponse listSourceRepositoryBranchesResponse = (ListSourceRepositoryBranchesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSourceRepositoryBranches").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listSourceRepositoryBranchesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSourceRepositoryBranchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSourceRepositoryBranchesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$listSourceRepositoryBranches$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSourceRepositoryBranchesIterable listSourceRepositoryBranchesPaginator(ListSourceRepositoryBranchesRequest listSourceRepositoryBranchesRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        return new ListSourceRepositoryBranchesIterable(this, this.applyPaginatorUserAgent(listSourceRepositoryBranchesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSpacesResponse listSpaces(ListSpacesRequest listSpacesRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSpacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, listSpacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSpaces");
            ListSpacesResponse listSpacesResponse = (ListSpacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSpaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listSpacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSpacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSpacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$listSpaces$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSpacesIterable listSpacesPaginator(ListSpacesRequest listSpacesRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        return new ListSpacesIterable(this, this.applyPaginatorUserAgent(listSpacesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDevEnvironmentResponse startDevEnvironment(StartDevEnvironmentRequest startDevEnvironmentRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDevEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, startDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDevEnvironment");
            StartDevEnvironmentResponse startDevEnvironmentResponse = (StartDevEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDevEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)startDevEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDevEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$startDevEnvironment$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDevEnvironmentSessionResponse startDevEnvironmentSession(StartDevEnvironmentSessionRequest startDevEnvironmentSessionRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDevEnvironmentSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, startDevEnvironmentSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDevEnvironmentSession");
            StartDevEnvironmentSessionResponse startDevEnvironmentSessionResponse = (StartDevEnvironmentSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDevEnvironmentSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)startDevEnvironmentSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDevEnvironmentSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDevEnvironmentSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$startDevEnvironmentSession$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDevEnvironmentResponse stopDevEnvironment(StopDevEnvironmentRequest stopDevEnvironmentRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDevEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, stopDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDevEnvironment");
            StopDevEnvironmentResponse stopDevEnvironmentResponse = (StopDevEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDevEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)stopDevEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopDevEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$stopDevEnvironment$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDevEnvironmentSessionResponse stopDevEnvironmentSession(StopDevEnvironmentSessionRequest stopDevEnvironmentSessionRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDevEnvironmentSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, stopDevEnvironmentSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDevEnvironmentSession");
            StopDevEnvironmentSessionResponse stopDevEnvironmentSessionResponse = (StopDevEnvironmentSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDevEnvironmentSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)stopDevEnvironmentSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopDevEnvironmentSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopDevEnvironmentSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$stopDevEnvironmentSession$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDevEnvironmentResponse updateDevEnvironment(UpdateDevEnvironmentRequest updateDevEnvironmentRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDevEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, updateDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDevEnvironment");
            UpdateDevEnvironmentResponse updateDevEnvironmentResponse = (UpdateDevEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDevEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)updateDevEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDevEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$updateDevEnvironment$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifySessionResponse verifySession(VerifySessionRequest verifySessionRequest) throws ThrottlingException, ConflictException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CodeCatalystException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifySessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystClient.resolveMetricPublishers(this.clientConfiguration, verifySessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifySession");
            VerifySessionResponse verifySessionResponse = (VerifySessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifySession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).credentialType(CredentialType.TOKEN).withInput((SdkRequest)verifySessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifySessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifySessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystClient.lambda$verifySession$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends CodeCatalystRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.47").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeCatalystRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "codecatalyst";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeCatalystException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build());
    }

    @Override
    public final CodeCatalystServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$verifySession$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDevEnvironment$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDevEnvironmentSession$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDevEnvironment$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDevEnvironmentSession$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDevEnvironment$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSpaces$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSourceRepositoryBranches$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSourceRepositories$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProjects$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventLogs$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevEnvironments$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessTokens$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserDetails$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSubscription$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSpace$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSourceRepositoryCloneUrls$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProject$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDevEnvironment$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDevEnvironment$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessToken$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSourceRepositoryBranch$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProject$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDevEnvironment$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessToken$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

