/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuildArtifacts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BuildArtifacts> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BuildArtifacts.getter(BuildArtifacts::location)).setter(BuildArtifacts.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> SHA256_SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BuildArtifacts.getter(BuildArtifacts::sha256sum)).setter(BuildArtifacts.setter(Builder::sha256sum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha256sum").build()}).build();
    private static final SdkField<String> MD5_SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BuildArtifacts.getter(BuildArtifacts::md5sum)).setter(BuildArtifacts.setter(Builder::md5sum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("md5sum").build()}).build();
    private static final SdkField<Boolean> OVERRIDE_ARTIFACT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(BuildArtifacts.getter(BuildArtifacts::overrideArtifactName)).setter(BuildArtifacts.setter(Builder::overrideArtifactName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideArtifactName").build()}).build();
    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(BuildArtifacts.getter(BuildArtifacts::encryptionDisabled)).setter(BuildArtifacts.setter(Builder::encryptionDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDisabled").build()}).build();
    private static final SdkField<String> ARTIFACT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BuildArtifacts.getter(BuildArtifacts::artifactIdentifier)).setter(BuildArtifacts.setter(Builder::artifactIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, SHA256_SUM_FIELD, MD5_SUM_FIELD, OVERRIDE_ARTIFACT_NAME_FIELD, ENCRYPTION_DISABLED_FIELD, ARTIFACT_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String location;
    private final String sha256sum;
    private final String md5sum;
    private final Boolean overrideArtifactName;
    private final Boolean encryptionDisabled;
    private final String artifactIdentifier;

    private BuildArtifacts(BuilderImpl builder) {
        this.location = builder.location;
        this.sha256sum = builder.sha256sum;
        this.md5sum = builder.md5sum;
        this.overrideArtifactName = builder.overrideArtifactName;
        this.encryptionDisabled = builder.encryptionDisabled;
        this.artifactIdentifier = builder.artifactIdentifier;
    }

    public String location() {
        return this.location;
    }

    public String sha256sum() {
        return this.sha256sum;
    }

    public String md5sum() {
        return this.md5sum;
    }

    public Boolean overrideArtifactName() {
        return this.overrideArtifactName;
    }

    public Boolean encryptionDisabled() {
        return this.encryptionDisabled;
    }

    public String artifactIdentifier() {
        return this.artifactIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildArtifacts)) {
            return false;
        }
        BuildArtifacts other = (BuildArtifacts)obj;
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.sha256sum(), other.sha256sum()) && Objects.equals(this.md5sum(), other.md5sum()) && Objects.equals(this.overrideArtifactName(), other.overrideArtifactName()) && Objects.equals(this.encryptionDisabled(), other.encryptionDisabled()) && Objects.equals(this.artifactIdentifier(), other.artifactIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"BuildArtifacts").add("Location", (Object)this.location()).add("Sha256sum", (Object)this.sha256sum()).add("Md5sum", (Object)this.md5sum()).add("OverrideArtifactName", (Object)this.overrideArtifactName()).add("EncryptionDisabled", (Object)this.encryptionDisabled()).add("ArtifactIdentifier", (Object)this.artifactIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "sha256sum": {
                return Optional.ofNullable(clazz.cast(this.sha256sum()));
            }
            case "md5sum": {
                return Optional.ofNullable(clazz.cast(this.md5sum()));
            }
            case "overrideArtifactName": {
                return Optional.ofNullable(clazz.cast(this.overrideArtifactName()));
            }
            case "encryptionDisabled": {
                return Optional.ofNullable(clazz.cast(this.encryptionDisabled()));
            }
            case "artifactIdentifier": {
                return Optional.ofNullable(clazz.cast(this.artifactIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildArtifacts, T> g) {
        return obj -> g.apply((BuildArtifacts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String location;
        private String sha256sum;
        private String md5sum;
        private Boolean overrideArtifactName;
        private Boolean encryptionDisabled;
        private String artifactIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildArtifacts model) {
            this.location(model.location);
            this.sha256sum(model.sha256sum);
            this.md5sum(model.md5sum);
            this.overrideArtifactName(model.overrideArtifactName);
            this.encryptionDisabled(model.encryptionDisabled);
            this.artifactIdentifier(model.artifactIdentifier);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getSha256sum() {
            return this.sha256sum;
        }

        @Override
        public final Builder sha256sum(String sha256sum) {
            this.sha256sum = sha256sum;
            return this;
        }

        public final void setSha256sum(String sha256sum) {
            this.sha256sum = sha256sum;
        }

        public final String getMd5sum() {
            return this.md5sum;
        }

        @Override
        public final Builder md5sum(String md5sum) {
            this.md5sum = md5sum;
            return this;
        }

        public final void setMd5sum(String md5sum) {
            this.md5sum = md5sum;
        }

        public final Boolean getOverrideArtifactName() {
            return this.overrideArtifactName;
        }

        @Override
        public final Builder overrideArtifactName(Boolean overrideArtifactName) {
            this.overrideArtifactName = overrideArtifactName;
            return this;
        }

        public final void setOverrideArtifactName(Boolean overrideArtifactName) {
            this.overrideArtifactName = overrideArtifactName;
        }

        public final Boolean getEncryptionDisabled() {
            return this.encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        public final String getArtifactIdentifier() {
            return this.artifactIdentifier;
        }

        @Override
        public final Builder artifactIdentifier(String artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
            return this;
        }

        public final void setArtifactIdentifier(String artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        public BuildArtifacts build() {
            return new BuildArtifacts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BuildArtifacts> {
        public Builder location(String var1);

        public Builder sha256sum(String var1);

        public Builder md5sum(String var1);

        public Builder overrideArtifactName(Boolean var1);

        public Builder encryptionDisabled(Boolean var1);

        public Builder artifactIdentifier(String var1);
    }
}

