/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CacheMode;
import software.amazon.awssdk.services.codebuild.model.CacheType;
import software.amazon.awssdk.services.codebuild.model.ProjectCacheModesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectCache
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectCache> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectCache.getter(ProjectCache::typeAsString)).setter(ProjectCache.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectCache.getter(ProjectCache::location)).setter(ProjectCache.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<List<String>> MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProjectCache.getter(ProjectCache::modesAsStrings)).setter(ProjectCache.setter(Builder::modesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOCATION_FIELD, MODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String location;
    private final List<String> modes;

    private ProjectCache(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.modes = builder.modes;
    }

    public CacheType type() {
        return CacheType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public List<CacheMode> modes() {
        return TypeConverter.convert(this.modes, CacheMode::fromValue);
    }

    public List<String> modesAsStrings() {
        return this.modes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.modesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectCache)) {
            return false;
        }
        ProjectCache other = (ProjectCache)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.modesAsStrings(), other.modesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ProjectCache").add("Type", (Object)this.typeAsString()).add("Location", (Object)this.location()).add("Modes", this.modesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "modes": {
                return Optional.ofNullable(clazz.cast(this.modesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectCache, T> g) {
        return obj -> g.apply((ProjectCache)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private List<String> modes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectCache model) {
            this.type(model.type);
            this.location(model.location);
            this.modesWithStrings(model.modes);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CacheType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Collection<String> getModesAsStrings() {
            return this.modes;
        }

        @Override
        public final Builder modesWithStrings(Collection<String> modes) {
            this.modes = ProjectCacheModesCopier.copy(modes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modesWithStrings(String ... modes) {
            this.modesWithStrings(Arrays.asList(modes));
            return this;
        }

        @Override
        public final Builder modes(Collection<CacheMode> modes) {
            this.modes = ProjectCacheModesCopier.copyEnumToString(modes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modes(CacheMode ... modes) {
            this.modes(Arrays.asList(modes));
            return this;
        }

        public final void setModesWithStrings(Collection<String> modes) {
            this.modes = ProjectCacheModesCopier.copy(modes);
        }

        public ProjectCache build() {
            return new ProjectCache(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectCache> {
        public Builder type(String var1);

        public Builder type(CacheType var1);

        public Builder location(String var1);

        public Builder modesWithStrings(Collection<String> var1);

        public Builder modesWithStrings(String ... var1);

        public Builder modes(Collection<CacheMode> var1);

        public Builder modes(CacheMode ... var1);
    }
}

