/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ProjectVisibilityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProjectVisibilityRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, UpdateProjectVisibilityRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(UpdateProjectVisibilityRequest.getter(UpdateProjectVisibilityRequest::projectArn)).setter(UpdateProjectVisibilityRequest.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> PROJECT_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectVisibility").getter(UpdateProjectVisibilityRequest.getter(UpdateProjectVisibilityRequest::projectVisibilityAsString)).setter(UpdateProjectVisibilityRequest.setter(Builder::projectVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectVisibility").build()}).build();
    private static final SdkField<String> RESOURCE_ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceAccessRole").getter(UpdateProjectVisibilityRequest.getter(UpdateProjectVisibilityRequest::resourceAccessRole)).setter(UpdateProjectVisibilityRequest.setter(Builder::resourceAccessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceAccessRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, PROJECT_VISIBILITY_FIELD, RESOURCE_ACCESS_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProjectVisibilityRequest.memberNameToFieldInitializer();
    private final String projectArn;
    private final String projectVisibility;
    private final String resourceAccessRole;

    private UpdateProjectVisibilityRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.projectVisibility = builder.projectVisibility;
        this.resourceAccessRole = builder.resourceAccessRole;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final ProjectVisibilityType projectVisibility() {
        return ProjectVisibilityType.fromValue(this.projectVisibility);
    }

    public final String projectVisibilityAsString() {
        return this.projectVisibility;
    }

    public final String resourceAccessRole() {
        return this.resourceAccessRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAccessRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectVisibilityRequest)) {
            return false;
        }
        UpdateProjectVisibilityRequest other = (UpdateProjectVisibilityRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.projectVisibilityAsString(), other.projectVisibilityAsString()) && Objects.equals(this.resourceAccessRole(), other.resourceAccessRole());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProjectVisibilityRequest").add("ProjectArn", (Object)this.projectArn()).add("ProjectVisibility", (Object)this.projectVisibilityAsString()).add("ResourceAccessRole", (Object)this.resourceAccessRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "projectVisibility": {
                return Optional.ofNullable(clazz.cast(this.projectVisibilityAsString()));
            }
            case "resourceAccessRole": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("projectVisibility", PROJECT_VISIBILITY_FIELD);
        map.put("resourceAccessRole", RESOURCE_ACCESS_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectVisibilityRequest, T> g) {
        return obj -> g.apply((UpdateProjectVisibilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String projectVisibility;
        private String resourceAccessRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectVisibilityRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.projectVisibility(model.projectVisibility);
            this.resourceAccessRole(model.resourceAccessRole);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectVisibility() {
            return this.projectVisibility;
        }

        public final void setProjectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
        }

        @Override
        public final Builder projectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
            return this;
        }

        @Override
        public final Builder projectVisibility(ProjectVisibilityType projectVisibility) {
            this.projectVisibility(projectVisibility == null ? null : projectVisibility.toString());
            return this;
        }

        public final String getResourceAccessRole() {
            return this.resourceAccessRole;
        }

        public final void setResourceAccessRole(String resourceAccessRole) {
            this.resourceAccessRole = resourceAccessRole;
        }

        @Override
        public final Builder resourceAccessRole(String resourceAccessRole) {
            this.resourceAccessRole = resourceAccessRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectVisibilityRequest build() {
            return new UpdateProjectVisibilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProjectVisibilityRequest> {
        public Builder projectArn(String var1);

        public Builder projectVisibility(String var1);

        public Builder projectVisibility(ProjectVisibilityType var1);

        public Builder resourceAccessRole(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

