/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.Build;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.services.codebuild.model.BuildsCopier;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetBuildsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetBuildsResponse> {
    private static final SdkField<List<Build>> BUILDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("builds").getter(BatchGetBuildsResponse.getter(BatchGetBuildsResponse::builds)).setter(BatchGetBuildsResponse.setter(Builder::builds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("builds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Build::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BUILDS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buildsNotFound").getter(BatchGetBuildsResponse.getter(BatchGetBuildsResponse::buildsNotFound)).setter(BatchGetBuildsResponse.setter(Builder::buildsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILDS_FIELD, BUILDS_NOT_FOUND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetBuildsResponse.memberNameToFieldInitializer();
    private final List<Build> builds;
    private final List<String> buildsNotFound;

    private BatchGetBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.builds = builder.builds;
        this.buildsNotFound = builder.buildsNotFound;
    }

    public final boolean hasBuilds() {
        return this.builds != null && !(this.builds instanceof SdkAutoConstructList);
    }

    public final List<Build> builds() {
        return this.builds;
    }

    public final boolean hasBuildsNotFound() {
        return this.buildsNotFound != null && !(this.buildsNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> buildsNotFound() {
        return this.buildsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuilds() ? this.builds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuildsNotFound() ? this.buildsNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBuildsResponse)) {
            return false;
        }
        BatchGetBuildsResponse other = (BatchGetBuildsResponse)((Object)obj);
        return this.hasBuilds() == other.hasBuilds() && Objects.equals(this.builds(), other.builds()) && this.hasBuildsNotFound() == other.hasBuildsNotFound() && Objects.equals(this.buildsNotFound(), other.buildsNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetBuildsResponse").add("Builds", this.hasBuilds() ? this.builds() : null).add("BuildsNotFound", this.hasBuildsNotFound() ? this.buildsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "builds": {
                return Optional.ofNullable(clazz.cast(this.builds()));
            }
            case "buildsNotFound": {
                return Optional.ofNullable(clazz.cast(this.buildsNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("builds", BUILDS_FIELD);
        map.put("buildsNotFound", BUILDS_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetBuildsResponse, T> g) {
        return obj -> g.apply((BatchGetBuildsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<Build> builds = DefaultSdkAutoConstructList.getInstance();
        private List<String> buildsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBuildsResponse model) {
            super(model);
            this.builds(model.builds);
            this.buildsNotFound(model.buildsNotFound);
        }

        public final List<Build.Builder> getBuilds() {
            List<Build.Builder> result = BuildsCopier.copyToBuilder(this.builds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuilds(Collection<Build.BuilderImpl> builds) {
            this.builds = BuildsCopier.copyFromBuilder(builds);
        }

        @Override
        public final Builder builds(Collection<Build> builds) {
            this.builds = BuildsCopier.copy(builds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Build ... builds) {
            this.builds(Arrays.asList(builds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Consumer<Build.Builder> ... builds) {
            this.builds(Stream.of(builds).map(c -> (Build)((Build.Builder)Build.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getBuildsNotFound() {
            if (this.buildsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.buildsNotFound;
        }

        public final void setBuildsNotFound(Collection<String> buildsNotFound) {
            this.buildsNotFound = BuildIdsCopier.copy(buildsNotFound);
        }

        @Override
        public final Builder buildsNotFound(Collection<String> buildsNotFound) {
            this.buildsNotFound = BuildIdsCopier.copy(buildsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotFound(String ... buildsNotFound) {
            this.buildsNotFound(Arrays.asList(buildsNotFound));
            return this;
        }

        @Override
        public BatchGetBuildsResponse build() {
            return new BatchGetBuildsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetBuildsResponse> {
        public Builder builds(Collection<Build> var1);

        public Builder builds(Build ... var1);

        public Builder builds(Consumer<Build.Builder> ... var1);

        public Builder buildsNotFound(Collection<String> var1);

        public Builder buildsNotFound(String ... var1);
    }
}

