/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommandType {
    SHELL("SHELL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommandType> VALUE_MAP;
    private final String value;

    private CommandType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommandType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommandType> knownValues() {
        EnumSet<CommandType> knownValues = EnumSet.allOf(CommandType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommandType.class, CommandType::toString);
    }
}

