/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse;
import software.amazon.awssdk.services.codebuild.model.TestCase;

public class DescribeTestCasesIterable
implements SdkIterable<DescribeTestCasesResponse> {
    private final CodeBuildClient client;
    private final DescribeTestCasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTestCasesIterable(CodeBuildClient client, DescribeTestCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTestCasesResponseFetcher();
    }

    public Iterator<DescribeTestCasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TestCase> testCases() {
        Function<DescribeTestCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testCases() != null) {
                return response.testCases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTestCasesResponseFetcher
    implements SyncPageFetcher<DescribeTestCasesResponse> {
        private DescribeTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTestCasesResponse nextPage(DescribeTestCasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTestCasesIterable.this.client.describeTestCases(DescribeTestCasesIterable.this.firstRequest);
            }
            return DescribeTestCasesIterable.this.client.describeTestCases((DescribeTestCasesRequest)((Object)DescribeTestCasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

