/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesForProjectResponse;

public class ListSandboxesForProjectPublisher
implements SdkPublisher<ListSandboxesForProjectResponse> {
    private final CodeBuildAsyncClient client;
    private final ListSandboxesForProjectRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSandboxesForProjectPublisher(CodeBuildAsyncClient client, ListSandboxesForProjectRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSandboxesForProjectPublisher(CodeBuildAsyncClient client, ListSandboxesForProjectRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSandboxesForProjectResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSandboxesForProjectResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> ids() {
        Function<ListSandboxesForProjectResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSandboxesForProjectResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSandboxesForProjectResponseFetcher
    implements AsyncPageFetcher<ListSandboxesForProjectResponse> {
        private ListSandboxesForProjectResponseFetcher() {
        }

        public boolean hasNextPage(ListSandboxesForProjectResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSandboxesForProjectResponse> nextPage(ListSandboxesForProjectResponse previousPage) {
            if (previousPage == null) {
                return ListSandboxesForProjectPublisher.this.client.listSandboxesForProject(ListSandboxesForProjectPublisher.this.firstRequest);
            }
            return ListSandboxesForProjectPublisher.this.client.listSandboxesForProject((ListSandboxesForProjectRequest)((Object)ListSandboxesForProjectPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

