/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.FleetArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFleetsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, ListFleetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFleetsResponse.getter(ListFleetsResponse::nextToken)).setter(ListFleetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> FLEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fleets").getter(ListFleetsResponse.getter(ListFleetsResponse::fleets)).setter(ListFleetsResponse.setter(Builder::fleets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FLEETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("fleets", FLEETS_FIELD);
        }
    });
    private final String nextToken;
    private final List<String> fleets;

    private ListFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.fleets = builder.fleets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFleets() {
        return this.fleets != null && !(this.fleets instanceof SdkAutoConstructList);
    }

    public final List<String> fleets() {
        return this.fleets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleets() ? this.fleets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsResponse)) {
            return false;
        }
        ListFleetsResponse other = (ListFleetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFleets() == other.hasFleets() && Objects.equals(this.fleets(), other.fleets());
    }

    public final String toString() {
        return ToString.builder((String)"ListFleetsResponse").add("NextToken", (Object)this.nextToken()).add("Fleets", this.hasFleets() ? this.fleets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "fleets": {
                return Optional.ofNullable(clazz.cast(this.fleets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFleetsResponse, T> g) {
        return obj -> g.apply((ListFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> fleets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.fleets(model.fleets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getFleets() {
            if (this.fleets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fleets;
        }

        public final void setFleets(Collection<String> fleets) {
            this.fleets = FleetArnsCopier.copy(fleets);
        }

        @Override
        public final Builder fleets(Collection<String> fleets) {
            this.fleets = FleetArnsCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(String ... fleets) {
            this.fleets(Arrays.asList(fleets));
            return this;
        }

        @Override
        public ListFleetsResponse build() {
            return new ListFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFleetsResponse> {
        public Builder nextToken(String var1);

        public Builder fleets(Collection<String> var1);

        public Builder fleets(String ... var1);
    }
}

