/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImagePullCredentialsType {
    CODEBUILD("CODEBUILD"),
    SERVICE_ROLE("SERVICE_ROLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImagePullCredentialsType> VALUE_MAP;
    private final String value;

    private ImagePullCredentialsType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImagePullCredentialsType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImagePullCredentialsType> knownValues() {
        EnumSet<ImagePullCredentialsType> knownValues = EnumSet.allOf(ImagePullCredentialsType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImagePullCredentialsType.class, ImagePullCredentialsType::toString);
    }
}

