/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse;

public class ListBuildBatchesIterable
implements SdkIterable<ListBuildBatchesResponse> {
    private final CodeBuildClient client;
    private final ListBuildBatchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBuildBatchesIterable(CodeBuildClient client, ListBuildBatchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBuildBatchesResponseFetcher();
    }

    public Iterator<ListBuildBatchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> ids() {
        Function<ListBuildBatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBuildBatchesResponseFetcher
    implements SyncPageFetcher<ListBuildBatchesResponse> {
        private ListBuildBatchesResponseFetcher() {
        }

        public boolean hasNextPage(ListBuildBatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBuildBatchesResponse nextPage(ListBuildBatchesResponse previousPage) {
            if (previousPage == null) {
                return ListBuildBatchesIterable.this.client.listBuildBatches(ListBuildBatchesIterable.this.firstRequest);
            }
            return ListBuildBatchesIterable.this.client.listBuildBatches((ListBuildBatchesRequest)((Object)ListBuildBatchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

