/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LanguageType {
    JAVA("JAVA"),
    PYTHON("PYTHON"),
    NODE_JS("NODE_JS"),
    RUBY("RUBY"),
    GOLANG("GOLANG"),
    DOCKER("DOCKER"),
    ANDROID("ANDROID"),
    DOTNET("DOTNET"),
    BASE("BASE"),
    PHP("PHP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LanguageType> VALUE_MAP;
    private final String value;

    private LanguageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageType> knownValues() {
        EnumSet<LanguageType> knownValues = EnumSet.allOf(LanguageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LanguageType.class, LanguageType::toString);
    }
}

