/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClientBuilder;
import software.amazon.awssdk.services.codebuild.CodeBuildServiceClientConfiguration;
import software.amazon.awssdk.services.codebuild.DefaultCodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.DefaultCodeBuildBaseClientBuilder;
import software.amazon.awssdk.services.codebuild.endpoints.CodeBuildEndpointProvider;

@SdkInternalApi
final class DefaultCodeBuildAsyncClientBuilder
extends DefaultCodeBuildBaseClientBuilder<CodeBuildAsyncClientBuilder, CodeBuildAsyncClient>
implements CodeBuildAsyncClientBuilder {
    DefaultCodeBuildAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeBuildAsyncClientBuilder endpointProvider(CodeBuildEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeBuildAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeBuildAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeBuildServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeBuildAsyncClient client = new DefaultCodeBuildAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeBuildServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeBuildServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

