/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType;
import software.amazon.awssdk.services.codebuild.model.RegistryCredential;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectEnvironment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectEnvironment> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ProjectEnvironment.getter(ProjectEnvironment::typeAsString)).setter(ProjectEnvironment.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(ProjectEnvironment.getter(ProjectEnvironment::image)).setter(ProjectEnvironment.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeType").getter(ProjectEnvironment.getter(ProjectEnvironment::computeTypeAsString)).setter(ProjectEnvironment.setter(Builder::computeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()}).build();
    private static final SdkField<List<EnvironmentVariable>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentVariables").getter(ProjectEnvironment.getter(ProjectEnvironment::environmentVariables)).setter(ProjectEnvironment.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privilegedMode").getter(ProjectEnvironment.getter(ProjectEnvironment::privilegedMode)).setter(ProjectEnvironment.setter(Builder::privilegedMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privilegedMode").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificate").getter(ProjectEnvironment.getter(ProjectEnvironment::certificate)).setter(ProjectEnvironment.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()}).build();
    private static final SdkField<RegistryCredential> REGISTRY_CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("registryCredential").getter(ProjectEnvironment.getter(ProjectEnvironment::registryCredential)).setter(ProjectEnvironment.setter(Builder::registryCredential)).constructor(RegistryCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryCredential").build()}).build();
    private static final SdkField<String> IMAGE_PULL_CREDENTIALS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imagePullCredentialsType").getter(ProjectEnvironment.getter(ProjectEnvironment::imagePullCredentialsTypeAsString)).setter(ProjectEnvironment.setter(Builder::imagePullCredentialsType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePullCredentialsType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IMAGE_FIELD, COMPUTE_TYPE_FIELD, ENVIRONMENT_VARIABLES_FIELD, PRIVILEGED_MODE_FIELD, CERTIFICATE_FIELD, REGISTRY_CREDENTIAL_FIELD, IMAGE_PULL_CREDENTIALS_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String image;
    private final String computeType;
    private final List<EnvironmentVariable> environmentVariables;
    private final Boolean privilegedMode;
    private final String certificate;
    private final RegistryCredential registryCredential;
    private final String imagePullCredentialsType;

    private ProjectEnvironment(BuilderImpl builder) {
        this.type = builder.type;
        this.image = builder.image;
        this.computeType = builder.computeType;
        this.environmentVariables = builder.environmentVariables;
        this.privilegedMode = builder.privilegedMode;
        this.certificate = builder.certificate;
        this.registryCredential = builder.registryCredential;
        this.imagePullCredentialsType = builder.imagePullCredentialsType;
    }

    public final EnvironmentType type() {
        return EnvironmentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String image() {
        return this.image;
    }

    public final ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public final String computeTypeAsString() {
        return this.computeType;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public final Boolean privilegedMode() {
        return this.privilegedMode;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final RegistryCredential registryCredential() {
        return this.registryCredential;
    }

    public final ImagePullCredentialsType imagePullCredentialsType() {
        return ImagePullCredentialsType.fromValue(this.imagePullCredentialsType);
    }

    public final String imagePullCredentialsTypeAsString() {
        return this.imagePullCredentialsType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privilegedMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryCredential());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePullCredentialsTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectEnvironment)) {
            return false;
        }
        ProjectEnvironment other = (ProjectEnvironment)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.privilegedMode(), other.privilegedMode()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.registryCredential(), other.registryCredential()) && Objects.equals(this.imagePullCredentialsTypeAsString(), other.imagePullCredentialsTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectEnvironment").add("Type", (Object)this.typeAsString()).add("Image", (Object)this.image()).add("ComputeType", (Object)this.computeTypeAsString()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("PrivilegedMode", (Object)this.privilegedMode()).add("Certificate", (Object)this.certificate()).add("RegistryCredential", (Object)this.registryCredential()).add("ImagePullCredentialsType", (Object)this.imagePullCredentialsTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "computeType": {
                return Optional.ofNullable(clazz.cast(this.computeTypeAsString()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "privilegedMode": {
                return Optional.ofNullable(clazz.cast(this.privilegedMode()));
            }
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "registryCredential": {
                return Optional.ofNullable(clazz.cast(this.registryCredential()));
            }
            case "imagePullCredentialsType": {
                return Optional.ofNullable(clazz.cast(this.imagePullCredentialsTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectEnvironment, T> g) {
        return obj -> g.apply((ProjectEnvironment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String image;
        private String computeType;
        private List<EnvironmentVariable> environmentVariables = DefaultSdkAutoConstructList.getInstance();
        private Boolean privilegedMode;
        private String certificate;
        private RegistryCredential registryCredential;
        private String imagePullCredentialsType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectEnvironment model) {
            this.type(model.type);
            this.image(model.image);
            this.computeType(model.computeType);
            this.environmentVariables(model.environmentVariables);
            this.privilegedMode(model.privilegedMode);
            this.certificate(model.certificate);
            this.registryCredential(model.registryCredential);
            this.imagePullCredentialsType(model.imagePullCredentialsType);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EnvironmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final List<EnvironmentVariable.Builder> getEnvironmentVariables() {
            List<EnvironmentVariable.Builder> result = EnvironmentVariablesCopier.copyToBuilder(this.environmentVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVariables(Collection<EnvironmentVariable.BuilderImpl> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copyFromBuilder(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Collection<EnvironmentVariable> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(EnvironmentVariable ... environmentVariables) {
            this.environmentVariables(Arrays.asList(environmentVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(Consumer<EnvironmentVariable.Builder> ... environmentVariables) {
            this.environmentVariables(Stream.of(environmentVariables).map(c -> (EnvironmentVariable)((EnvironmentVariable.Builder)EnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivilegedMode() {
            return this.privilegedMode;
        }

        public final void setPrivilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
        }

        @Override
        public final Builder privilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final RegistryCredential.Builder getRegistryCredential() {
            return this.registryCredential != null ? this.registryCredential.toBuilder() : null;
        }

        public final void setRegistryCredential(RegistryCredential.BuilderImpl registryCredential) {
            this.registryCredential = registryCredential != null ? registryCredential.build() : null;
        }

        @Override
        public final Builder registryCredential(RegistryCredential registryCredential) {
            this.registryCredential = registryCredential;
            return this;
        }

        public final String getImagePullCredentialsType() {
            return this.imagePullCredentialsType;
        }

        public final void setImagePullCredentialsType(String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
        }

        @Override
        public final Builder imagePullCredentialsType(String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
            return this;
        }

        @Override
        public final Builder imagePullCredentialsType(ImagePullCredentialsType imagePullCredentialsType) {
            this.imagePullCredentialsType(imagePullCredentialsType == null ? null : imagePullCredentialsType.toString());
            return this;
        }

        public ProjectEnvironment build() {
            return new ProjectEnvironment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectEnvironment> {
        public Builder type(String var1);

        public Builder type(EnvironmentType var1);

        public Builder image(String var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder environmentVariables(Collection<EnvironmentVariable> var1);

        public Builder environmentVariables(EnvironmentVariable ... var1);

        public Builder environmentVariables(Consumer<EnvironmentVariable.Builder> ... var1);

        public Builder privilegedMode(Boolean var1);

        public Builder certificate(String var1);

        public Builder registryCredential(RegistryCredential var1);

        default public Builder registryCredential(Consumer<RegistryCredential.Builder> registryCredential) {
            return this.registryCredential((RegistryCredential)((RegistryCredential.Builder)RegistryCredential.builder().applyMutation(registryCredential)).build());
        }

        public Builder imagePullCredentialsType(String var1);

        public Builder imagePullCredentialsType(ImagePullCredentialsType var1);
    }
}

