/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.ResolvedArtifact;
import software.amazon.awssdk.services.codebuild.model.ResolvedSecondaryArtifactsCopier;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuildSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BuildSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(BuildSummary.getter(BuildSummary::arn)).setter(BuildSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> REQUESTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("requestedOn").getter(BuildSummary.getter(BuildSummary::requestedOn)).setter(BuildSummary.setter(Builder::requestedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedOn").build()}).build();
    private static final SdkField<String> BUILD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildStatus").getter(BuildSummary.getter(BuildSummary::buildStatusAsString)).setter(BuildSummary.setter(Builder::buildStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatus").build()}).build();
    private static final SdkField<ResolvedArtifact> PRIMARY_ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryArtifact").getter(BuildSummary.getter(BuildSummary::primaryArtifact)).setter(BuildSummary.setter(Builder::primaryArtifact)).constructor(ResolvedArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryArtifact").build()}).build();
    private static final SdkField<List<ResolvedArtifact>> SECONDARY_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondaryArtifacts").getter(BuildSummary.getter(BuildSummary::secondaryArtifacts)).setter(BuildSummary.setter(Builder::secondaryArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolvedArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, REQUESTED_ON_FIELD, BUILD_STATUS_FIELD, PRIMARY_ARTIFACT_FIELD, SECONDARY_ARTIFACTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant requestedOn;
    private final String buildStatus;
    private final ResolvedArtifact primaryArtifact;
    private final List<ResolvedArtifact> secondaryArtifacts;

    private BuildSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.requestedOn = builder.requestedOn;
        this.buildStatus = builder.buildStatus;
        this.primaryArtifact = builder.primaryArtifact;
        this.secondaryArtifacts = builder.secondaryArtifacts;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant requestedOn() {
        return this.requestedOn;
    }

    public final StatusType buildStatus() {
        return StatusType.fromValue(this.buildStatus);
    }

    public final String buildStatusAsString() {
        return this.buildStatus;
    }

    public final ResolvedArtifact primaryArtifact() {
        return this.primaryArtifact;
    }

    public final boolean hasSecondaryArtifacts() {
        return this.secondaryArtifacts != null && !(this.secondaryArtifacts instanceof SdkAutoConstructList);
    }

    public final List<ResolvedArtifact> secondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildSummary)) {
            return false;
        }
        BuildSummary other = (BuildSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.requestedOn(), other.requestedOn()) && Objects.equals(this.buildStatusAsString(), other.buildStatusAsString()) && Objects.equals(this.primaryArtifact(), other.primaryArtifact()) && this.hasSecondaryArtifacts() == other.hasSecondaryArtifacts() && Objects.equals(this.secondaryArtifacts(), other.secondaryArtifacts());
    }

    public final String toString() {
        return ToString.builder((String)"BuildSummary").add("Arn", (Object)this.arn()).add("RequestedOn", (Object)this.requestedOn()).add("BuildStatus", (Object)this.buildStatusAsString()).add("PrimaryArtifact", (Object)this.primaryArtifact()).add("SecondaryArtifacts", this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "requestedOn": {
                return Optional.ofNullable(clazz.cast(this.requestedOn()));
            }
            case "buildStatus": {
                return Optional.ofNullable(clazz.cast(this.buildStatusAsString()));
            }
            case "primaryArtifact": {
                return Optional.ofNullable(clazz.cast(this.primaryArtifact()));
            }
            case "secondaryArtifacts": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildSummary, T> g) {
        return obj -> g.apply((BuildSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant requestedOn;
        private String buildStatus;
        private ResolvedArtifact primaryArtifact;
        private List<ResolvedArtifact> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BuildSummary model) {
            this.arn(model.arn);
            this.requestedOn(model.requestedOn);
            this.buildStatus(model.buildStatus);
            this.primaryArtifact(model.primaryArtifact);
            this.secondaryArtifacts(model.secondaryArtifacts);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getRequestedOn() {
            return this.requestedOn;
        }

        public final void setRequestedOn(Instant requestedOn) {
            this.requestedOn = requestedOn;
        }

        @Override
        @Transient
        public final Builder requestedOn(Instant requestedOn) {
            this.requestedOn = requestedOn;
            return this;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        @Override
        @Transient
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder buildStatus(StatusType buildStatus) {
            this.buildStatus(buildStatus == null ? null : buildStatus.toString());
            return this;
        }

        public final ResolvedArtifact.Builder getPrimaryArtifact() {
            return this.primaryArtifact != null ? this.primaryArtifact.toBuilder() : null;
        }

        public final void setPrimaryArtifact(ResolvedArtifact.BuilderImpl primaryArtifact) {
            this.primaryArtifact = primaryArtifact != null ? primaryArtifact.build() : null;
        }

        @Override
        @Transient
        public final Builder primaryArtifact(ResolvedArtifact primaryArtifact) {
            this.primaryArtifact = primaryArtifact;
            return this;
        }

        public final List<ResolvedArtifact.Builder> getSecondaryArtifacts() {
            List<ResolvedArtifact.Builder> result = ResolvedSecondaryArtifactsCopier.copyToBuilder(this.secondaryArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifacts(Collection<ResolvedArtifact.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = ResolvedSecondaryArtifactsCopier.copyFromBuilder(secondaryArtifacts);
        }

        @Override
        @Transient
        public final Builder secondaryArtifacts(Collection<ResolvedArtifact> secondaryArtifacts) {
            this.secondaryArtifacts = ResolvedSecondaryArtifactsCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondaryArtifacts(ResolvedArtifact ... secondaryArtifacts) {
            this.secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<ResolvedArtifact.Builder> ... secondaryArtifacts) {
            this.secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> (ResolvedArtifact)((ResolvedArtifact.Builder)ResolvedArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BuildSummary build() {
            return new BuildSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BuildSummary> {
        public Builder arn(String var1);

        public Builder requestedOn(Instant var1);

        public Builder buildStatus(String var1);

        public Builder buildStatus(StatusType var1);

        public Builder primaryArtifact(ResolvedArtifact var1);

        default public Builder primaryArtifact(Consumer<ResolvedArtifact.Builder> primaryArtifact) {
            return this.primaryArtifact((ResolvedArtifact)((ResolvedArtifact.Builder)ResolvedArtifact.builder().applyMutation(primaryArtifact)).build());
        }

        public Builder secondaryArtifacts(Collection<ResolvedArtifact> var1);

        public Builder secondaryArtifacts(ResolvedArtifact ... var1);

        public Builder secondaryArtifacts(Consumer<ResolvedArtifact.Builder> ... var1);
    }
}

