/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CloudWatchLogsConfig;
import software.amazon.awssdk.services.codebuild.model.S3LogsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogsLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogsLocation> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupName").getter(LogsLocation.getter(LogsLocation::groupName)).setter(LogsLocation.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamName").getter(LogsLocation.getter(LogsLocation::streamName)).setter(LogsLocation.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()}).build();
    private static final SdkField<String> DEEP_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deepLink").getter(LogsLocation.getter(LogsLocation::deepLink)).setter(LogsLocation.setter(Builder::deepLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deepLink").build()}).build();
    private static final SdkField<String> S3_DEEP_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3DeepLink").getter(LogsLocation.getter(LogsLocation::s3DeepLink)).setter(LogsLocation.setter(Builder::s3DeepLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DeepLink").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudWatchLogsArn").getter(LogsLocation.getter(LogsLocation::cloudWatchLogsArn)).setter(LogsLocation.setter(Builder::cloudWatchLogsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsArn").build()}).build();
    private static final SdkField<String> S3_LOGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3LogsArn").getter(LogsLocation.getter(LogsLocation::s3LogsArn)).setter(LogsLocation.setter(Builder::s3LogsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3LogsArn").build()}).build();
    private static final SdkField<CloudWatchLogsConfig> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(LogsLocation.getter(LogsLocation::cloudWatchLogs)).setter(LogsLocation.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<S3LogsConfig> S3_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Logs").getter(LogsLocation.getter(LogsLocation::s3Logs)).setter(LogsLocation.setter(Builder::s3Logs)).constructor(S3LogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, STREAM_NAME_FIELD, DEEP_LINK_FIELD, S3_DEEP_LINK_FIELD, CLOUD_WATCH_LOGS_ARN_FIELD, S3_LOGS_ARN_FIELD, CLOUD_WATCH_LOGS_FIELD, S3_LOGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String streamName;
    private final String deepLink;
    private final String s3DeepLink;
    private final String cloudWatchLogsArn;
    private final String s3LogsArn;
    private final CloudWatchLogsConfig cloudWatchLogs;
    private final S3LogsConfig s3Logs;

    private LogsLocation(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.streamName = builder.streamName;
        this.deepLink = builder.deepLink;
        this.s3DeepLink = builder.s3DeepLink;
        this.cloudWatchLogsArn = builder.cloudWatchLogsArn;
        this.s3LogsArn = builder.s3LogsArn;
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.s3Logs = builder.s3Logs;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String deepLink() {
        return this.deepLink;
    }

    public final String s3DeepLink() {
        return this.s3DeepLink;
    }

    public final String cloudWatchLogsArn() {
        return this.cloudWatchLogsArn;
    }

    public final String s3LogsArn() {
        return this.s3LogsArn;
    }

    public final CloudWatchLogsConfig cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final S3LogsConfig s3Logs() {
        return this.s3Logs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deepLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DeepLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3LogsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Logs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsLocation)) {
            return false;
        }
        LogsLocation other = (LogsLocation)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.deepLink(), other.deepLink()) && Objects.equals(this.s3DeepLink(), other.s3DeepLink()) && Objects.equals(this.cloudWatchLogsArn(), other.cloudWatchLogsArn()) && Objects.equals(this.s3LogsArn(), other.s3LogsArn()) && Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.s3Logs(), other.s3Logs());
    }

    public final String toString() {
        return ToString.builder((String)"LogsLocation").add("GroupName", (Object)this.groupName()).add("StreamName", (Object)this.streamName()).add("DeepLink", (Object)this.deepLink()).add("S3DeepLink", (Object)this.s3DeepLink()).add("CloudWatchLogsArn", (Object)this.cloudWatchLogsArn()).add("S3LogsArn", (Object)this.s3LogsArn()).add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("S3Logs", (Object)this.s3Logs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "streamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "deepLink": {
                return Optional.ofNullable(clazz.cast(this.deepLink()));
            }
            case "s3DeepLink": {
                return Optional.ofNullable(clazz.cast(this.s3DeepLink()));
            }
            case "cloudWatchLogsArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsArn()));
            }
            case "s3LogsArn": {
                return Optional.ofNullable(clazz.cast(this.s3LogsArn()));
            }
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "s3Logs": {
                return Optional.ofNullable(clazz.cast(this.s3Logs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogsLocation, T> g) {
        return obj -> g.apply((LogsLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String streamName;
        private String deepLink;
        private String s3DeepLink;
        private String cloudWatchLogsArn;
        private String s3LogsArn;
        private CloudWatchLogsConfig cloudWatchLogs;
        private S3LogsConfig s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsLocation model) {
            this.groupName(model.groupName);
            this.streamName(model.streamName);
            this.deepLink(model.deepLink);
            this.s3DeepLink(model.s3DeepLink);
            this.cloudWatchLogsArn(model.cloudWatchLogsArn);
            this.s3LogsArn(model.s3LogsArn);
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.s3Logs(model.s3Logs);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        @Transient
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getDeepLink() {
            return this.deepLink;
        }

        public final void setDeepLink(String deepLink) {
            this.deepLink = deepLink;
        }

        @Override
        @Transient
        public final Builder deepLink(String deepLink) {
            this.deepLink = deepLink;
            return this;
        }

        public final String getS3DeepLink() {
            return this.s3DeepLink;
        }

        public final void setS3DeepLink(String s3DeepLink) {
            this.s3DeepLink = s3DeepLink;
        }

        @Override
        @Transient
        public final Builder s3DeepLink(String s3DeepLink) {
            this.s3DeepLink = s3DeepLink;
            return this;
        }

        public final String getCloudWatchLogsArn() {
            return this.cloudWatchLogsArn;
        }

        public final void setCloudWatchLogsArn(String cloudWatchLogsArn) {
            this.cloudWatchLogsArn = cloudWatchLogsArn;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogsArn(String cloudWatchLogsArn) {
            this.cloudWatchLogsArn = cloudWatchLogsArn;
            return this;
        }

        public final String getS3LogsArn() {
            return this.s3LogsArn;
        }

        public final void setS3LogsArn(String s3LogsArn) {
            this.s3LogsArn = s3LogsArn;
        }

        @Override
        @Transient
        public final Builder s3LogsArn(String s3LogsArn) {
            this.s3LogsArn = s3LogsArn;
            return this;
        }

        public final CloudWatchLogsConfig.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsConfig.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogs(CloudWatchLogsConfig cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final S3LogsConfig.Builder getS3Logs() {
            return this.s3Logs != null ? this.s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(S3LogsConfig.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Logs(S3LogsConfig s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public LogsLocation build() {
            return new LogsLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogsLocation> {
        public Builder groupName(String var1);

        public Builder streamName(String var1);

        public Builder deepLink(String var1);

        public Builder s3DeepLink(String var1);

        public Builder cloudWatchLogsArn(String var1);

        public Builder s3LogsArn(String var1);

        public Builder cloudWatchLogs(CloudWatchLogsConfig var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsConfig.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsConfig)((CloudWatchLogsConfig.Builder)CloudWatchLogsConfig.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder s3Logs(S3LogsConfig var1);

        default public Builder s3Logs(Consumer<S3LogsConfig.Builder> s3Logs) {
            return this.s3Logs((S3LogsConfig)((S3LogsConfig.Builder)S3LogsConfig.builder().applyMutation(s3Logs)).build());
        }
    }
}

