/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildBatch;
import software.amazon.awssdk.services.codebuild.model.BuildBatchIdsCopier;
import software.amazon.awssdk.services.codebuild.model.BuildBatchesCopier;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetBuildBatchesResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetBuildBatchesResponse> {
    private static final SdkField<List<BuildBatch>> BUILD_BATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buildBatches").getter(BatchGetBuildBatchesResponse.getter(BatchGetBuildBatchesResponse::buildBatches)).setter(BatchGetBuildBatchesResponse.setter(Builder::buildBatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildBatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BUILD_BATCHES_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buildBatchesNotFound").getter(BatchGetBuildBatchesResponse.getter(BatchGetBuildBatchesResponse::buildBatchesNotFound)).setter(BatchGetBuildBatchesResponse.setter(Builder::buildBatchesNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchesNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_BATCHES_FIELD, BUILD_BATCHES_NOT_FOUND_FIELD));
    private final List<BuildBatch> buildBatches;
    private final List<String> buildBatchesNotFound;

    private BatchGetBuildBatchesResponse(BuilderImpl builder) {
        super(builder);
        this.buildBatches = builder.buildBatches;
        this.buildBatchesNotFound = builder.buildBatchesNotFound;
    }

    public final boolean hasBuildBatches() {
        return this.buildBatches != null && !(this.buildBatches instanceof SdkAutoConstructList);
    }

    public final List<BuildBatch> buildBatches() {
        return this.buildBatches;
    }

    public final boolean hasBuildBatchesNotFound() {
        return this.buildBatchesNotFound != null && !(this.buildBatchesNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> buildBatchesNotFound() {
        return this.buildBatchesNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuildBatches() ? this.buildBatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuildBatchesNotFound() ? this.buildBatchesNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBuildBatchesResponse)) {
            return false;
        }
        BatchGetBuildBatchesResponse other = (BatchGetBuildBatchesResponse)((Object)obj);
        return this.hasBuildBatches() == other.hasBuildBatches() && Objects.equals(this.buildBatches(), other.buildBatches()) && this.hasBuildBatchesNotFound() == other.hasBuildBatchesNotFound() && Objects.equals(this.buildBatchesNotFound(), other.buildBatchesNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetBuildBatchesResponse").add("BuildBatches", this.hasBuildBatches() ? this.buildBatches() : null).add("BuildBatchesNotFound", this.hasBuildBatchesNotFound() ? this.buildBatchesNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "buildBatches": {
                return Optional.ofNullable(clazz.cast(this.buildBatches()));
            }
            case "buildBatchesNotFound": {
                return Optional.ofNullable(clazz.cast(this.buildBatchesNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetBuildBatchesResponse, T> g) {
        return obj -> g.apply((BatchGetBuildBatchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<BuildBatch> buildBatches = DefaultSdkAutoConstructList.getInstance();
        private List<String> buildBatchesNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBuildBatchesResponse model) {
            super(model);
            this.buildBatches(model.buildBatches);
            this.buildBatchesNotFound(model.buildBatchesNotFound);
        }

        public final List<BuildBatch.Builder> getBuildBatches() {
            List<BuildBatch.Builder> result = BuildBatchesCopier.copyToBuilder(this.buildBatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuildBatches(Collection<BuildBatch.BuilderImpl> buildBatches) {
            this.buildBatches = BuildBatchesCopier.copyFromBuilder(buildBatches);
        }

        @Override
        @Transient
        public final Builder buildBatches(Collection<BuildBatch> buildBatches) {
            this.buildBatches = BuildBatchesCopier.copy(buildBatches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder buildBatches(BuildBatch ... buildBatches) {
            this.buildBatches(Arrays.asList(buildBatches));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder buildBatches(Consumer<BuildBatch.Builder> ... buildBatches) {
            this.buildBatches(Stream.of(buildBatches).map(c -> (BuildBatch)((BuildBatch.Builder)BuildBatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getBuildBatchesNotFound() {
            if (this.buildBatchesNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.buildBatchesNotFound;
        }

        public final void setBuildBatchesNotFound(Collection<String> buildBatchesNotFound) {
            this.buildBatchesNotFound = BuildBatchIdsCopier.copy(buildBatchesNotFound);
        }

        @Override
        @Transient
        public final Builder buildBatchesNotFound(Collection<String> buildBatchesNotFound) {
            this.buildBatchesNotFound = BuildBatchIdsCopier.copy(buildBatchesNotFound);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder buildBatchesNotFound(String ... buildBatchesNotFound) {
            this.buildBatchesNotFound(Arrays.asList(buildBatchesNotFound));
            return this;
        }

        @Override
        public BatchGetBuildBatchesResponse build() {
            return new BatchGetBuildBatchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetBuildBatchesResponse> {
        public Builder buildBatches(Collection<BuildBatch> var1);

        public Builder buildBatches(BuildBatch ... var1);

        public Builder buildBatches(Consumer<BuildBatch.Builder> ... var1);

        public Builder buildBatchesNotFound(Collection<String> var1);

        public Builder buildBatchesNotFound(String ... var1);
    }
}

