/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.ArtifactsType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolvedArtifact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolvedArtifact> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ResolvedArtifact.getter(ResolvedArtifact::typeAsString)).setter(ResolvedArtifact.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(ResolvedArtifact.getter(ResolvedArtifact::location)).setter(ResolvedArtifact.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(ResolvedArtifact.getter(ResolvedArtifact::identifier)).setter(ResolvedArtifact.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOCATION_FIELD, IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String location;
    private final String identifier;

    private ResolvedArtifact(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.identifier = builder.identifier;
    }

    public final ArtifactsType type() {
        return ArtifactsType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String location() {
        return this.location;
    }

    public final String identifier() {
        return this.identifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedArtifact)) {
            return false;
        }
        ResolvedArtifact other = (ResolvedArtifact)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.identifier(), other.identifier());
    }

    public final String toString() {
        return ToString.builder((String)"ResolvedArtifact").add("Type", (Object)this.typeAsString()).add("Location", (Object)this.location()).add("Identifier", (Object)this.identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolvedArtifact, T> g) {
        return obj -> g.apply((ResolvedArtifact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedArtifact model) {
            this.type(model.type);
            this.location(model.location);
            this.identifier(model.identifier);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ArtifactsType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        @Transient
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Transient
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public ResolvedArtifact build() {
            return new ResolvedArtifact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolvedArtifact> {
        public Builder type(String var1);

        public Builder type(ArtifactsType var1);

        public Builder location(String var1);

        public Builder identifier(String var1);
    }
}

