/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WebhookFilterType {
    EVENT("EVENT"),
    BASE_REF("BASE_REF"),
    HEAD_REF("HEAD_REF"),
    ACTOR_ACCOUNT_ID("ACTOR_ACCOUNT_ID"),
    FILE_PATH("FILE_PATH"),
    COMMIT_MESSAGE("COMMIT_MESSAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WebhookFilterType> VALUE_MAP;
    private final String value;

    private WebhookFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WebhookFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WebhookFilterType> knownValues() {
        EnumSet<WebhookFilterType> knownValues = EnumSet.allOf(WebhookFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WebhookFilterType.class, WebhookFilterType::toString);
    }
}

