/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse;

public class ListBuildBatchesPublisher
implements SdkPublisher<ListBuildBatchesResponse> {
    private final CodeBuildAsyncClient client;
    private final ListBuildBatchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBuildBatchesPublisher(CodeBuildAsyncClient client, ListBuildBatchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBuildBatchesPublisher(CodeBuildAsyncClient client, ListBuildBatchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBuildBatchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBuildBatchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> ids() {
        Function<ListBuildBatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBuildBatchesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBuildBatchesResponseFetcher
    implements AsyncPageFetcher<ListBuildBatchesResponse> {
        private ListBuildBatchesResponseFetcher() {
        }

        public boolean hasNextPage(ListBuildBatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBuildBatchesResponse> nextPage(ListBuildBatchesResponse previousPage) {
            if (previousPage == null) {
                return ListBuildBatchesPublisher.this.client.listBuildBatches(ListBuildBatchesPublisher.this.firstRequest);
            }
            return ListBuildBatchesPublisher.this.client.listBuildBatches((ListBuildBatchesRequest)((Object)ListBuildBatchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

