/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildSummariesCopier;
import software.amazon.awssdk.services.codebuild.model.BuildSummary;
import software.amazon.awssdk.services.codebuild.model.IdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuildGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BuildGroup> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(BuildGroup.getter(BuildGroup::identifier)).setter(BuildGroup.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<List<String>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependsOn").getter(BuildGroup.getter(BuildGroup::dependsOn)).setter(BuildGroup.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IGNORE_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ignoreFailure").getter(BuildGroup.getter(BuildGroup::ignoreFailure)).setter(BuildGroup.setter(Builder::ignoreFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreFailure").build()}).build();
    private static final SdkField<BuildSummary> CURRENT_BUILD_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentBuildSummary").getter(BuildGroup.getter(BuildGroup::currentBuildSummary)).setter(BuildGroup.setter(Builder::currentBuildSummary)).constructor(BuildSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBuildSummary").build()}).build();
    private static final SdkField<List<BuildSummary>> PRIOR_BUILD_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("priorBuildSummaryList").getter(BuildGroup.getter(BuildGroup::priorBuildSummaryList)).setter(BuildGroup.setter(Builder::priorBuildSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priorBuildSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, DEPENDS_ON_FIELD, IGNORE_FAILURE_FIELD, CURRENT_BUILD_SUMMARY_FIELD, PRIOR_BUILD_SUMMARY_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final List<String> dependsOn;
    private final Boolean ignoreFailure;
    private final BuildSummary currentBuildSummary;
    private final List<BuildSummary> priorBuildSummaryList;

    private BuildGroup(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.dependsOn = builder.dependsOn;
        this.ignoreFailure = builder.ignoreFailure;
        this.currentBuildSummary = builder.currentBuildSummary;
        this.priorBuildSummaryList = builder.priorBuildSummaryList;
    }

    public String identifier() {
        return this.identifier;
    }

    public boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public List<String> dependsOn() {
        return this.dependsOn;
    }

    public Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    public BuildSummary currentBuildSummary() {
        return this.currentBuildSummary;
    }

    public boolean hasPriorBuildSummaryList() {
        return this.priorBuildSummaryList != null && !(this.priorBuildSummaryList instanceof SdkAutoConstructList);
    }

    public List<BuildSummary> priorBuildSummaryList() {
        return this.priorBuildSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dependsOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBuildSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.priorBuildSummaryList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildGroup)) {
            return false;
        }
        BuildGroup other = (BuildGroup)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.dependsOn(), other.dependsOn()) && Objects.equals(this.ignoreFailure(), other.ignoreFailure()) && Objects.equals(this.currentBuildSummary(), other.currentBuildSummary()) && Objects.equals(this.priorBuildSummaryList(), other.priorBuildSummaryList());
    }

    public String toString() {
        return ToString.builder((String)"BuildGroup").add("Identifier", (Object)this.identifier()).add("DependsOn", this.dependsOn()).add("IgnoreFailure", (Object)this.ignoreFailure()).add("CurrentBuildSummary", (Object)this.currentBuildSummary()).add("PriorBuildSummaryList", this.priorBuildSummaryList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "dependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
            case "ignoreFailure": {
                return Optional.ofNullable(clazz.cast(this.ignoreFailure()));
            }
            case "currentBuildSummary": {
                return Optional.ofNullable(clazz.cast(this.currentBuildSummary()));
            }
            case "priorBuildSummaryList": {
                return Optional.ofNullable(clazz.cast(this.priorBuildSummaryList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildGroup, T> g) {
        return obj -> g.apply((BuildGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private List<String> dependsOn = DefaultSdkAutoConstructList.getInstance();
        private Boolean ignoreFailure;
        private BuildSummary currentBuildSummary;
        private List<BuildSummary> priorBuildSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BuildGroup model) {
            this.identifier(model.identifier);
            this.dependsOn(model.dependsOn);
            this.ignoreFailure(model.ignoreFailure);
            this.currentBuildSummary(model.currentBuildSummary);
            this.priorBuildSummaryList(model.priorBuildSummaryList);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final Collection<String> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final Builder dependsOn(Collection<String> dependsOn) {
            this.dependsOn = IdentifiersCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(String ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        public final void setDependsOn(Collection<String> dependsOn) {
            this.dependsOn = IdentifiersCopier.copy(dependsOn);
        }

        public final Boolean getIgnoreFailure() {
            return this.ignoreFailure;
        }

        @Override
        public final Builder ignoreFailure(Boolean ignoreFailure) {
            this.ignoreFailure = ignoreFailure;
            return this;
        }

        public final void setIgnoreFailure(Boolean ignoreFailure) {
            this.ignoreFailure = ignoreFailure;
        }

        public final BuildSummary.Builder getCurrentBuildSummary() {
            return this.currentBuildSummary != null ? this.currentBuildSummary.toBuilder() : null;
        }

        @Override
        public final Builder currentBuildSummary(BuildSummary currentBuildSummary) {
            this.currentBuildSummary = currentBuildSummary;
            return this;
        }

        public final void setCurrentBuildSummary(BuildSummary.BuilderImpl currentBuildSummary) {
            this.currentBuildSummary = currentBuildSummary != null ? currentBuildSummary.build() : null;
        }

        public final Collection<BuildSummary.Builder> getPriorBuildSummaryList() {
            return this.priorBuildSummaryList != null ? (Collection)this.priorBuildSummaryList.stream().map(BuildSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder priorBuildSummaryList(Collection<BuildSummary> priorBuildSummaryList) {
            this.priorBuildSummaryList = BuildSummariesCopier.copy(priorBuildSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorBuildSummaryList(BuildSummary ... priorBuildSummaryList) {
            this.priorBuildSummaryList(Arrays.asList(priorBuildSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorBuildSummaryList(Consumer<BuildSummary.Builder> ... priorBuildSummaryList) {
            this.priorBuildSummaryList(Stream.of(priorBuildSummaryList).map(c -> (BuildSummary)((BuildSummary.Builder)BuildSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPriorBuildSummaryList(Collection<BuildSummary.BuilderImpl> priorBuildSummaryList) {
            this.priorBuildSummaryList = BuildSummariesCopier.copyFromBuilder(priorBuildSummaryList);
        }

        public BuildGroup build() {
            return new BuildGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BuildGroup> {
        public Builder identifier(String var1);

        public Builder dependsOn(Collection<String> var1);

        public Builder dependsOn(String ... var1);

        public Builder ignoreFailure(Boolean var1);

        public Builder currentBuildSummary(BuildSummary var1);

        default public Builder currentBuildSummary(Consumer<BuildSummary.Builder> currentBuildSummary) {
            return this.currentBuildSummary((BuildSummary)((BuildSummary.Builder)BuildSummary.builder().applyMutation(currentBuildSummary)).build());
        }

        public Builder priorBuildSummaryList(Collection<BuildSummary> var1);

        public Builder priorBuildSummaryList(BuildSummary ... var1);

        public Builder priorBuildSummaryList(Consumer<BuildSummary.Builder> ... var1);
    }
}

