/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.services.codebuild.model.BuildNotDeleted;
import software.amazon.awssdk.services.codebuild.model.BuildsNotDeletedCopier;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteBuildBatchResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, DeleteBuildBatchResponse> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteBuildBatchResponse.getter(DeleteBuildBatchResponse::statusCode)).setter(DeleteBuildBatchResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<List<String>> BUILDS_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeleteBuildBatchResponse.getter(DeleteBuildBatchResponse::buildsDeleted)).setter(DeleteBuildBatchResponse.setter(Builder::buildsDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsDeleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BuildNotDeleted>> BUILDS_NOT_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeleteBuildBatchResponse.getter(DeleteBuildBatchResponse::buildsNotDeleted)).setter(DeleteBuildBatchResponse.setter(Builder::buildsNotDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsNotDeleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildNotDeleted::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, BUILDS_DELETED_FIELD, BUILDS_NOT_DELETED_FIELD));
    private final String statusCodeValue;
    private final List<String> buildsDeleted;
    private final List<BuildNotDeleted> buildsNotDeleted;

    private DeleteBuildBatchResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
        this.buildsDeleted = builder.buildsDeleted;
        this.buildsNotDeleted = builder.buildsNotDeleted;
    }

    public String statusCode() {
        return this.statusCodeValue;
    }

    public boolean hasBuildsDeleted() {
        return this.buildsDeleted != null && !(this.buildsDeleted instanceof SdkAutoConstructList);
    }

    public List<String> buildsDeleted() {
        return this.buildsDeleted;
    }

    public boolean hasBuildsNotDeleted() {
        return this.buildsNotDeleted != null && !(this.buildsNotDeleted instanceof SdkAutoConstructList);
    }

    public List<BuildNotDeleted> buildsNotDeleted() {
        return this.buildsNotDeleted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildsDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildsNotDeleted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBuildBatchResponse)) {
            return false;
        }
        DeleteBuildBatchResponse other = (DeleteBuildBatchResponse)((Object)obj);
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.buildsDeleted(), other.buildsDeleted()) && Objects.equals(this.buildsNotDeleted(), other.buildsNotDeleted());
    }

    public String toString() {
        return ToString.builder((String)"DeleteBuildBatchResponse").add("StatusCode", (Object)this.statusCode()).add("BuildsDeleted", this.buildsDeleted()).add("BuildsNotDeleted", this.buildsNotDeleted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "buildsDeleted": {
                return Optional.ofNullable(clazz.cast(this.buildsDeleted()));
            }
            case "buildsNotDeleted": {
                return Optional.ofNullable(clazz.cast(this.buildsNotDeleted()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBuildBatchResponse, T> g) {
        return obj -> g.apply((DeleteBuildBatchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private String statusCodeValue;
        private List<String> buildsDeleted = DefaultSdkAutoConstructList.getInstance();
        private List<BuildNotDeleted> buildsNotDeleted = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBuildBatchResponse model) {
            super(model);
            this.statusCode(model.statusCodeValue);
            this.buildsDeleted(model.buildsDeleted);
            this.buildsNotDeleted(model.buildsNotDeleted);
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final Collection<String> getBuildsDeleted() {
            return this.buildsDeleted;
        }

        @Override
        public final Builder buildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsDeleted(String ... buildsDeleted) {
            this.buildsDeleted(Arrays.asList(buildsDeleted));
            return this;
        }

        public final void setBuildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
        }

        public final Collection<BuildNotDeleted.Builder> getBuildsNotDeleted() {
            return this.buildsNotDeleted != null ? (Collection)this.buildsNotDeleted.stream().map(BuildNotDeleted::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buildsNotDeleted(Collection<BuildNotDeleted> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copy(buildsNotDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(BuildNotDeleted ... buildsNotDeleted) {
            this.buildsNotDeleted(Arrays.asList(buildsNotDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(Consumer<BuildNotDeleted.Builder> ... buildsNotDeleted) {
            this.buildsNotDeleted(Stream.of(buildsNotDeleted).map(c -> (BuildNotDeleted)((BuildNotDeleted.Builder)BuildNotDeleted.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBuildsNotDeleted(Collection<BuildNotDeleted.BuilderImpl> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copyFromBuilder(buildsNotDeleted);
        }

        @Override
        public DeleteBuildBatchResponse build() {
            return new DeleteBuildBatchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteBuildBatchResponse> {
        public Builder statusCode(String var1);

        public Builder buildsDeleted(Collection<String> var1);

        public Builder buildsDeleted(String ... var1);

        public Builder buildsNotDeleted(Collection<BuildNotDeleted> var1);

        public Builder buildsNotDeleted(BuildNotDeleted ... var1);

        public Builder buildsNotDeleted(Consumer<BuildNotDeleted.Builder> ... var1);
    }
}

