/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetReportsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchGetReportsResponse.Builder, BatchGetReportsResponse> {
    private static final SdkField<List<Report>> REPORTS_FIELD = SdkField
            .<List<Report>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetReportsResponse::reports))
            .setter(setter(Builder::reports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Report> builder(MarshallingType.SDK_POJO)
                                            .constructor(Report::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPORTS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetReportsResponse::reportsNotFound))
            .setter(setter(Builder::reportsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORTS_FIELD,
            REPORTS_NOT_FOUND_FIELD));

    private final List<Report> reports;

    private final List<String> reportsNotFound;

    private BatchGetReportsResponse(BuilderImpl builder) {
        super(builder);
        this.reports = builder.reports;
        this.reportsNotFound = builder.reportsNotFound;
    }

    /**
     * Returns true if the Reports property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReports() {
        return reports != null && !(reports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
     */
    public List<Report> reports() {
        return reports;
    }

    /**
     * Returns true if the ReportsNotFound property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReportsNotFound() {
        return reportsNotFound != null && !(reportsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>Report</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReportsNotFound()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
     *         <code>Report</code>.
     */
    public List<String> reportsNotFound() {
        return reportsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reports());
        hashCode = 31 * hashCode + Objects.hashCode(reportsNotFound());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetReportsResponse)) {
            return false;
        }
        BatchGetReportsResponse other = (BatchGetReportsResponse) obj;
        return Objects.equals(reports(), other.reports()) && Objects.equals(reportsNotFound(), other.reportsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetReportsResponse").add("Reports", reports()).add("ReportsNotFound", reportsNotFound())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reports":
            return Optional.ofNullable(clazz.cast(reports()));
        case "reportsNotFound":
            return Optional.ofNullable(clazz.cast(reportsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetReportsResponse, T> g) {
        return obj -> g.apply((BatchGetReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetReportsResponse> {
        /**
         * <p>
         * The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
         * </p>
         * 
         * @param reports
         *        The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(Collection<Report> reports);

        /**
         * <p>
         * The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
         * </p>
         * 
         * @param reports
         *        The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(Report... reports);

        /**
         * <p>
         * The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Report>.Builder} avoiding the need to
         * create one manually via {@link List<Report>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Report>.Builder#build()} is called immediately and its
         * result is passed to {@link #reports(List<Report>)}.
         * 
         * @param reports
         *        a consumer that will call methods on {@link List<Report>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reports(List<Report>)
         */
        Builder reports(Consumer<Report.Builder>... reports);

        /**
         * <p>
         * An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
         * <code>Report</code>.
         * </p>
         * 
         * @param reportsNotFound
         *        An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
         *        <code>Report</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportsNotFound(Collection<String> reportsNotFound);

        /**
         * <p>
         * An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
         * <code>Report</code>.
         * </p>
         * 
         * @param reportsNotFound
         *        An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
         *        <code>Report</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportsNotFound(String... reportsNotFound);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<Report> reports = DefaultSdkAutoConstructList.getInstance();

        private List<String> reportsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetReportsResponse model) {
            super(model);
            reports(model.reports);
            reportsNotFound(model.reportsNotFound);
        }

        public final Collection<Report.Builder> getReports() {
            return reports != null ? reports.stream().map(Report::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reports(Collection<Report> reports) {
            this.reports = ReportsCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Report... reports) {
            reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Consumer<Report.Builder>... reports) {
            reports(Stream.of(reports).map(c -> Report.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReports(Collection<Report.BuilderImpl> reports) {
            this.reports = ReportsCopier.copyFromBuilder(reports);
        }

        public final Collection<String> getReportsNotFound() {
            return reportsNotFound;
        }

        @Override
        public final Builder reportsNotFound(Collection<String> reportsNotFound) {
            this.reportsNotFound = ReportArnsCopier.copy(reportsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportsNotFound(String... reportsNotFound) {
            reportsNotFound(Arrays.asList(reportsNotFound));
            return this;
        }

        public final void setReportsNotFound(Collection<String> reportsNotFound) {
            this.reportsNotFound = ReportArnsCopier.copy(reportsNotFound);
        }

        @Override
        public BatchGetReportsResponse build() {
            return new BatchGetReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
