/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectRequest extends CodeBuildRequest implements
        ToCopyableBuilder<UpdateProjectRequest.Builder, UpdateProjectRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProjectRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProjectRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.<ProjectSource> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateProjectRequest::source)).setter(setter(Builder::source)).constructor(ProjectSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField
            .<List<ProjectSource>> builder(MarshallingType.LIST)
            .getter(getter(UpdateProjectRequest::secondarySources))
            .setter(setter(Builder::secondarySources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProjectRequest::sourceVersion)).setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField
            .<List<ProjectSourceVersion>> builder(MarshallingType.LIST)
            .getter(getter(UpdateProjectRequest::secondarySourceVersions))
            .setter(setter(Builder::secondarySourceVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSourceVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSourceVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProjectArtifacts> ARTIFACTS_FIELD = SdkField
            .<ProjectArtifacts> builder(MarshallingType.SDK_POJO).getter(getter(UpdateProjectRequest::artifacts))
            .setter(setter(Builder::artifacts)).constructor(ProjectArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()).build();

    private static final SdkField<List<ProjectArtifacts>> SECONDARY_ARTIFACTS_FIELD = SdkField
            .<List<ProjectArtifacts>> builder(MarshallingType.LIST)
            .getter(getter(UpdateProjectRequest::secondaryArtifacts))
            .setter(setter(Builder::secondaryArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectArtifacts> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectArtifacts::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProjectCache> CACHE_FIELD = SdkField.<ProjectCache> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateProjectRequest::cache)).setter(setter(Builder::cache)).constructor(ProjectCache::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cache").build()).build();

    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField
            .<ProjectEnvironment> builder(MarshallingType.SDK_POJO).getter(getter(UpdateProjectRequest::environment))
            .setter(setter(Builder::environment)).constructor(ProjectEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProjectRequest::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateProjectRequest::timeoutInMinutes)).setter(setter(Builder::timeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()).build();

    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateProjectRequest::queuedTimeoutInMinutes)).setter(setter(Builder::queuedTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build())
            .build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProjectRequest::encryptionKey)).setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(UpdateProjectRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateProjectRequest::vpcConfig)).setter(setter(Builder::vpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<Boolean> BADGE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateProjectRequest::badgeEnabled)).setter(setter(Builder::badgeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("badgeEnabled").build()).build();

    private static final SdkField<LogsConfig> LOGS_CONFIG_FIELD = SdkField.<LogsConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateProjectRequest::logsConfig)).setter(setter(Builder::logsConfig))
            .constructor(LogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SOURCE_FIELD, SECONDARY_SOURCES_FIELD, SOURCE_VERSION_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD, ARTIFACTS_FIELD,
            SECONDARY_ARTIFACTS_FIELD, CACHE_FIELD, ENVIRONMENT_FIELD, SERVICE_ROLE_FIELD, TIMEOUT_IN_MINUTES_FIELD,
            QUEUED_TIMEOUT_IN_MINUTES_FIELD, ENCRYPTION_KEY_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD, BADGE_ENABLED_FIELD,
            LOGS_CONFIG_FIELD));

    private final String name;

    private final String description;

    private final ProjectSource source;

    private final List<ProjectSource> secondarySources;

    private final String sourceVersion;

    private final List<ProjectSourceVersion> secondarySourceVersions;

    private final ProjectArtifacts artifacts;

    private final List<ProjectArtifacts> secondaryArtifacts;

    private final ProjectCache cache;

    private final ProjectEnvironment environment;

    private final String serviceRole;

    private final Integer timeoutInMinutes;

    private final Integer queuedTimeoutInMinutes;

    private final String encryptionKey;

    private final List<Tag> tags;

    private final VpcConfig vpcConfig;

    private final Boolean badgeEnabled;

    private final LogsConfig logsConfig;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.source = builder.source;
        this.secondarySources = builder.secondarySources;
        this.sourceVersion = builder.sourceVersion;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.artifacts = builder.artifacts;
        this.secondaryArtifacts = builder.secondaryArtifacts;
        this.cache = builder.cache;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.encryptionKey = builder.encryptionKey;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
        this.badgeEnabled = builder.badgeEnabled;
        this.logsConfig = builder.logsConfig;
    }

    /**
     * <p>
     * The name of the build project.
     * </p>
     * <note>
     * <p>
     * You cannot change a build project's name.
     * </p>
     * </note>
     * 
     * @return The name of the build project.</p> <note>
     *         <p>
     *         You cannot change a build project's name.
     *         </p>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A new or replacement description of the build project.
     * </p>
     * 
     * @return A new or replacement description of the build project.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Information to be changed about the build input source code for the build project.
     * </p>
     * 
     * @return Information to be changed about the build input source code for the build project.
     */
    public ProjectSource source() {
        return source;
    }

    /**
     * Returns true if the SecondarySources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecondarySources() {
        return secondarySources != null && !(secondarySources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecondarySources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProjectSource</code> objects.
     */
    public List<ProjectSource> secondarySources() {
        return secondarySources;
    }

    /**
     * <p>
     * A version of the build input to be built for this project. If not specified, the latest version is used. If
     * specified, it must be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For AWS CodeCommit: the commit ID, branch, or Git tag to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the
     * source code you want to build. If a pull request ID is specified, it must use the format
     * <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's
     * HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you
     * want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default
     * branch's HEAD commit ID is used.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon Simple Storage Service (Amazon S3): the version ID of the object that represents the build input ZIP
     * file to use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this
     * <code>sourceVersion</code> (at the project level).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
     * with CodeBuild</a> in the <i>AWS CodeBuild User Guide</i>.
     * </p>
     * 
     * @return A version of the build input to be built for this project. If not specified, the latest version is used.
     *         If specified, it must be one of: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For AWS CodeCommit: the commit ID, branch, or Git tag to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of
     *         the source code you want to build. If a pull request ID is specified, it must use the format
     *         <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the
     *         branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code
     *         you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified,
     *         the default branch's HEAD commit ID is used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Amazon Simple Storage Service (Amazon S3): the version ID of the object that represents the build
     *         input ZIP file to use.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over
     *         this <code>sourceVersion</code> (at the project level).
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version
     *         Sample with CodeBuild</a> in the <i>AWS CodeBuild User Guide</i>.
     */
    public String sourceVersion() {
        return sourceVersion;
    }

    /**
     * Returns true if the SecondarySourceVersions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecondarySourceVersions() {
        return secondarySourceVersions != null && !(secondarySourceVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified at
     * the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecondarySourceVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is
     *         specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the
     *         project level).
     */
    public List<ProjectSourceVersion> secondarySourceVersions() {
        return secondarySourceVersions;
    }

    /**
     * <p>
     * Information to be changed about the build output artifacts for the build project.
     * </p>
     * 
     * @return Information to be changed about the build output artifacts for the build project.
     */
    public ProjectArtifacts artifacts() {
        return artifacts;
    }

    /**
     * Returns true if the SecondaryArtifacts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecondaryArtifacts() {
        return secondaryArtifacts != null && !(secondaryArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecondaryArtifacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>ProjectSource</code> objects.
     */
    public List<ProjectArtifacts> secondaryArtifacts() {
        return secondaryArtifacts;
    }

    /**
     * <p>
     * Stores recently used information so that it can be quickly accessed at a later time.
     * </p>
     * 
     * @return Stores recently used information so that it can be quickly accessed at a later time.
     */
    public ProjectCache cache() {
        return cache;
    }

    /**
     * <p>
     * Information to be changed about the build environment for the build project.
     * </p>
     * 
     * @return Information to be changed about the build environment for the build project.
     */
    public ProjectEnvironment environment() {
        return environment;
    }

    /**
     * <p>
     * The replacement ARN of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact
     * with dependent AWS services on behalf of the AWS account.
     * </p>
     * 
     * @return The replacement ARN of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to
     *         interact with dependent AWS services on behalf of the AWS account.
     */
    public String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The replacement value in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out any
     * related build that did not get marked as completed.
     * </p>
     * 
     * @return The replacement value in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out
     *         any related build that did not get marked as completed.
     */
    public Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    /**
     * <p>
     * The number of minutes a build is allowed to be queued before it times out.
     * </p>
     * 
     * @return The number of minutes a build is allowed to be queued before it times out.
     */
    public Integer queuedTimeoutInMinutes() {
        return queuedTimeoutInMinutes;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build output
     * artifacts.
     * </p>
     * <note>
     * <p>
     * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to
     * that key.
     * </p>
     * </note>
     * <p>
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the
     * format <code>alias/<i>alias-name</i> </code>).
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build
     *         output artifacts.</p> <note>
     *         <p>
     *         You can use a cross-account KMS key to encrypt the build output artifacts if your service role has
     *         permission to that key.
     *         </p>
     *         </note>
     *         <p>
     *         You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
     *         the format <code>alias/<i>alias-name</i> </code>).
     */
    public String encryptionKey() {
        return encryptionKey;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replacement set of tags for this build project.
     * </p>
     * <p>
     * These tags are available for use by AWS services that support AWS CodeBuild build project tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The replacement set of tags for this build project.</p>
     *         <p>
     *         These tags are available for use by AWS services that support AWS CodeBuild build project tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
     * </p>
     * 
     * @return VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Set this to true to generate a publicly accessible URL for your project's build badge.
     * </p>
     * 
     * @return Set this to true to generate a publicly accessible URL for your project's build badge.
     */
    public Boolean badgeEnabled() {
        return badgeEnabled;
    }

    /**
     * <p>
     * Information about logs for the build project. A project can create logs in Amazon CloudWatch Logs, logs in an S3
     * bucket, or both.
     * </p>
     * 
     * @return Information about logs for the build project. A project can create logs in Amazon CloudWatch Logs, logs
     *         in an S3 bucket, or both.
     */
    public LogsConfig logsConfig() {
        return logsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(secondarySources());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(secondarySourceVersions());
        hashCode = 31 * hashCode + Objects.hashCode(artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(cache());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(badgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(logsConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(source(), other.source()) && Objects.equals(secondarySources(), other.secondarySources())
                && Objects.equals(sourceVersion(), other.sourceVersion())
                && Objects.equals(secondarySourceVersions(), other.secondarySourceVersions())
                && Objects.equals(artifacts(), other.artifacts())
                && Objects.equals(secondaryArtifacts(), other.secondaryArtifacts()) && Objects.equals(cache(), other.cache())
                && Objects.equals(environment(), other.environment()) && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(timeoutInMinutes(), other.timeoutInMinutes())
                && Objects.equals(queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes())
                && Objects.equals(encryptionKey(), other.encryptionKey()) && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(badgeEnabled(), other.badgeEnabled())
                && Objects.equals(logsConfig(), other.logsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateProjectRequest").add("Name", name()).add("Description", description())
                .add("Source", source()).add("SecondarySources", secondarySources()).add("SourceVersion", sourceVersion())
                .add("SecondarySourceVersions", secondarySourceVersions()).add("Artifacts", artifacts())
                .add("SecondaryArtifacts", secondaryArtifacts()).add("Cache", cache()).add("Environment", environment())
                .add("ServiceRole", serviceRole()).add("TimeoutInMinutes", timeoutInMinutes())
                .add("QueuedTimeoutInMinutes", queuedTimeoutInMinutes()).add("EncryptionKey", encryptionKey())
                .add("Tags", tags()).add("VpcConfig", vpcConfig()).add("BadgeEnabled", badgeEnabled())
                .add("LogsConfig", logsConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "secondarySources":
            return Optional.ofNullable(clazz.cast(secondarySources()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        case "secondarySourceVersions":
            return Optional.ofNullable(clazz.cast(secondarySourceVersions()));
        case "artifacts":
            return Optional.ofNullable(clazz.cast(artifacts()));
        case "secondaryArtifacts":
            return Optional.ofNullable(clazz.cast(secondaryArtifacts()));
        case "cache":
            return Optional.ofNullable(clazz.cast(cache()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "timeoutInMinutes":
            return Optional.ofNullable(clazz.cast(timeoutInMinutes()));
        case "queuedTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(queuedTimeoutInMinutes()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "badgeEnabled":
            return Optional.ofNullable(clazz.cast(badgeEnabled()));
        case "logsConfig":
            return Optional.ofNullable(clazz.cast(logsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProjectRequest> {
        /**
         * <p>
         * The name of the build project.
         * </p>
         * <note>
         * <p>
         * You cannot change a build project's name.
         * </p>
         * </note>
         * 
         * @param name
         *        The name of the build project.</p> <note>
         *        <p>
         *        You cannot change a build project's name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A new or replacement description of the build project.
         * </p>
         * 
         * @param description
         *        A new or replacement description of the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information to be changed about the build input source code for the build project.
         * </p>
         * 
         * @param source
         *        Information to be changed about the build input source code for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ProjectSource source);

        /**
         * <p>
         * Information to be changed about the build input source code for the build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectSource.Builder} avoiding the need to
         * create one manually via {@link ProjectSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ProjectSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ProjectSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ProjectSource)
         */
        default Builder source(Consumer<ProjectSource.Builder> source) {
            return source(ProjectSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySources
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySources(Collection<ProjectSource> secondarySources);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySources
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySources(ProjectSource... secondarySources);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectSource>.Builder} avoiding the need
         * to create one manually via {@link List<ProjectSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSource>.Builder#build()} is called immediately and
         * its result is passed to {@link #secondarySources(List<ProjectSource>)}.
         * 
         * @param secondarySources
         *        a consumer that will call methods on {@link List<ProjectSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySources(List<ProjectSource>)
         */
        Builder secondarySources(Consumer<ProjectSource.Builder>... secondarySources);

        /**
         * <p>
         * A version of the build input to be built for this project. If not specified, the latest version is used. If
         * specified, it must be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For AWS CodeCommit: the commit ID, branch, or Git tag to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the
         * source code you want to build. If a pull request ID is specified, it must use the format
         * <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's
         * HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you
         * want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the
         * default branch's HEAD commit ID is used.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Amazon Simple Storage Service (Amazon S3): the version ID of the object that represents the build input
         * ZIP file to use.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this
         * <code>sourceVersion</code> (at the project level).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version
         * Sample with CodeBuild</a> in the <i>AWS CodeBuild User Guide</i>.
         * </p>
         * 
         * @param sourceVersion
         *        A version of the build input to be built for this project. If not specified, the latest version is
         *        used. If specified, it must be one of: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For AWS CodeCommit: the commit ID, branch, or Git tag to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version
         *        of the source code you want to build. If a pull request ID is specified, it must use the format
         *        <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the
         *        branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source
         *        code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not
         *        specified, the default branch's HEAD commit ID is used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Amazon Simple Storage Service (Amazon S3): the version ID of the object that represents the build
         *        input ZIP file to use.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over
         *        this <code>sourceVersion</code> (at the project level).
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source
         *        Version Sample with CodeBuild</a> in the <i>AWS CodeBuild User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified
         * at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
         * </p>
         * 
         * @param secondarySourceVersions
         *        An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is
         *        specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the
         *        project level).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified
         * at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
         * </p>
         * 
         * @param secondarySourceVersions
         *        An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is
         *        specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the
         *        project level).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourceVersions(ProjectSourceVersion... secondarySourceVersions);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified
         * at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectSourceVersion>.Builder} avoiding the
         * need to create one manually via {@link List<ProjectSourceVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSourceVersion>.Builder#build()} is called immediately
         * and its result is passed to {@link #secondarySourceVersions(List<ProjectSourceVersion>)}.
         * 
         * @param secondarySourceVersions
         *        a consumer that will call methods on {@link List<ProjectSourceVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySourceVersions(List<ProjectSourceVersion>)
         */
        Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder>... secondarySourceVersions);

        /**
         * <p>
         * Information to be changed about the build output artifacts for the build project.
         * </p>
         * 
         * @param artifacts
         *        Information to be changed about the build output artifacts for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(ProjectArtifacts artifacts);

        /**
         * <p>
         * Information to be changed about the build output artifacts for the build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectArtifacts.Builder} avoiding the need to
         * create one manually via {@link ProjectArtifacts#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #artifacts(ProjectArtifacts)}.
         * 
         * @param artifacts
         *        a consumer that will call methods on {@link ProjectArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifacts(ProjectArtifacts)
         */
        default Builder artifacts(Consumer<ProjectArtifacts.Builder> artifacts) {
            return artifacts(ProjectArtifacts.builder().applyMutation(artifacts).build());
        }

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondaryArtifacts
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondaryArtifacts
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifacts(ProjectArtifacts... secondaryArtifacts);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectArtifacts>.Builder} avoiding the
         * need to create one manually via {@link List<ProjectArtifacts>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectArtifacts>.Builder#build()} is called immediately and
         * its result is passed to {@link #secondaryArtifacts(List<ProjectArtifacts>)}.
         * 
         * @param secondaryArtifacts
         *        a consumer that will call methods on {@link List<ProjectArtifacts>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryArtifacts(List<ProjectArtifacts>)
         */
        Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder>... secondaryArtifacts);

        /**
         * <p>
         * Stores recently used information so that it can be quickly accessed at a later time.
         * </p>
         * 
         * @param cache
         *        Stores recently used information so that it can be quickly accessed at a later time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cache(ProjectCache cache);

        /**
         * <p>
         * Stores recently used information so that it can be quickly accessed at a later time.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectCache.Builder} avoiding the need to
         * create one manually via {@link ProjectCache#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectCache.Builder#build()} is called immediately and its
         * result is passed to {@link #cache(ProjectCache)}.
         * 
         * @param cache
         *        a consumer that will call methods on {@link ProjectCache.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cache(ProjectCache)
         */
        default Builder cache(Consumer<ProjectCache.Builder> cache) {
            return cache(ProjectCache.builder().applyMutation(cache).build());
        }

        /**
         * <p>
         * Information to be changed about the build environment for the build project.
         * </p>
         * 
         * @param environment
         *        Information to be changed about the build environment for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(ProjectEnvironment environment);

        /**
         * <p>
         * Information to be changed about the build environment for the build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectEnvironment.Builder} avoiding the need to
         * create one manually via {@link ProjectEnvironment#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectEnvironment.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(ProjectEnvironment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link ProjectEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(ProjectEnvironment)
         */
        default Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return environment(ProjectEnvironment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The replacement ARN of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to
         * interact with dependent AWS services on behalf of the AWS account.
         * </p>
         * 
         * @param serviceRole
         *        The replacement ARN of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to
         *        interact with dependent AWS services on behalf of the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The replacement value in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out any
         * related build that did not get marked as completed.
         * </p>
         * 
         * @param timeoutInMinutes
         *        The replacement value in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait before timing out
         *        any related build that did not get marked as completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);

        /**
         * <p>
         * The number of minutes a build is allowed to be queued before it times out.
         * </p>
         * 
         * @param queuedTimeoutInMinutes
         *        The number of minutes a build is allowed to be queued before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes);

        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build output
         * artifacts.
         * </p>
         * <note>
         * <p>
         * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission
         * to that key.
         * </p>
         * </note>
         * <p>
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the
         * format <code>alias/<i>alias-name</i> </code>).
         * </p>
         * 
         * @param encryptionKey
         *        The AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build
         *        output artifacts.</p> <note>
         *        <p>
         *        You can use a cross-account KMS key to encrypt the build output artifacts if your service role has
         *        permission to that key.
         *        </p>
         *        </note>
         *        <p>
         *        You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias
         *        (using the format <code>alias/<i>alias-name</i> </code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * The replacement set of tags for this build project.
         * </p>
         * <p>
         * These tags are available for use by AWS services that support AWS CodeBuild build project tags.
         * </p>
         * 
         * @param tags
         *        The replacement set of tags for this build project.</p>
         *        <p>
         *        These tags are available for use by AWS services that support AWS CodeBuild build project tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The replacement set of tags for this build project.
         * </p>
         * <p>
         * These tags are available for use by AWS services that support AWS CodeBuild build project tags.
         * </p>
         * 
         * @param tags
         *        The replacement set of tags for this build project.</p>
         *        <p>
         *        These tags are available for use by AWS services that support AWS CodeBuild build project tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The replacement set of tags for this build project.
         * </p>
         * <p>
         * These tags are available for use by AWS services that support AWS CodeBuild build project tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
         * </p>
         * 
         * @param vpcConfig
         *        VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Set this to true to generate a publicly accessible URL for your project's build badge.
         * </p>
         * 
         * @param badgeEnabled
         *        Set this to true to generate a publicly accessible URL for your project's build badge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder badgeEnabled(Boolean badgeEnabled);

        /**
         * <p>
         * Information about logs for the build project. A project can create logs in Amazon CloudWatch Logs, logs in an
         * S3 bucket, or both.
         * </p>
         * 
         * @param logsConfig
         *        Information about logs for the build project. A project can create logs in Amazon CloudWatch Logs,
         *        logs in an S3 bucket, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsConfig(LogsConfig logsConfig);

        /**
         * <p>
         * Information about logs for the build project. A project can create logs in Amazon CloudWatch Logs, logs in an
         * S3 bucket, or both.
         * </p>
         * This is a convenience that creates an instance of the {@link LogsConfig.Builder} avoiding the need to create
         * one manually via {@link LogsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logsConfig(LogsConfig)}.
         * 
         * @param logsConfig
         *        a consumer that will call methods on {@link LogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsConfig(LogsConfig)
         */
        default Builder logsConfig(Consumer<LogsConfig.Builder> logsConfig) {
            return logsConfig(LogsConfig.builder().applyMutation(logsConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private ProjectSource source;

        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();

        private String sourceVersion;

        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();

        private ProjectArtifacts artifacts;

        private List<ProjectArtifacts> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();

        private ProjectCache cache;

        private ProjectEnvironment environment;

        private String serviceRole;

        private Integer timeoutInMinutes;

        private Integer queuedTimeoutInMinutes;

        private String encryptionKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private VpcConfig vpcConfig;

        private Boolean badgeEnabled;

        private LogsConfig logsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            source(model.source);
            secondarySources(model.secondarySources);
            sourceVersion(model.sourceVersion);
            secondarySourceVersions(model.secondarySourceVersions);
            artifacts(model.artifacts);
            secondaryArtifacts(model.secondaryArtifacts);
            cache(model.cache);
            environment(model.environment);
            serviceRole(model.serviceRole);
            timeoutInMinutes(model.timeoutInMinutes);
            queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            encryptionKey(model.encryptionKey);
            tags(model.tags);
            vpcConfig(model.vpcConfig);
            badgeEnabled(model.badgeEnabled);
            logsConfig(model.logsConfig);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ProjectSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<ProjectSource.Builder> getSecondarySources() {
            return secondarySources != null ? secondarySources.stream().map(ProjectSource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(ProjectSource... secondarySources) {
            secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder>... secondarySources) {
            secondarySources(Stream.of(secondarySources).map(c -> ProjectSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final Collection<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            return secondarySourceVersions != null ? secondarySourceVersions.stream().map(ProjectSourceVersion::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion... secondarySourceVersions) {
            secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder>... secondarySourceVersions) {
            secondarySourceVersions(Stream.of(secondarySourceVersions)
                    .map(c -> ProjectSourceVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        public final ProjectArtifacts.Builder getArtifacts() {
            return artifacts != null ? artifacts.toBuilder() : null;
        }

        @Override
        public final Builder artifacts(ProjectArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final void setArtifacts(ProjectArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        public final Collection<ProjectArtifacts.Builder> getSecondaryArtifacts() {
            return secondaryArtifacts != null ? secondaryArtifacts.stream().map(ProjectArtifacts::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(ProjectArtifacts... secondaryArtifacts) {
            secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder>... secondaryArtifacts) {
            secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> ProjectArtifacts.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryArtifacts(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        public final ProjectCache.Builder getCache() {
            return cache != null ? cache.toBuilder() : null;
        }

        @Override
        public final Builder cache(ProjectCache cache) {
            this.cache = cache;
            return this;
        }

        public final void setCache(ProjectCache.BuilderImpl cache) {
            this.cache = cache != null ? cache.build() : null;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return queuedTimeoutInMinutes;
        }

        @Override
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Boolean getBadgeEnabled() {
            return badgeEnabled;
        }

        @Override
        public final Builder badgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
            return this;
        }

        public final void setBadgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
        }

        public final LogsConfig.Builder getLogsConfig() {
            return logsConfig != null ? logsConfig.toBuilder() : null;
        }

        @Override
        public final Builder logsConfig(LogsConfig logsConfig) {
            this.logsConfig = logsConfig;
            return this;
        }

        public final void setLogsConfig(LogsConfig.BuilderImpl logsConfig) {
            this.logsConfig = logsConfig != null ? logsConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
