/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A series of reports. Each report contains information about the results from running a series of test cases. You
 * specify the test cases for a report group in the buildspec for a build project using one or more paths to the test
 * case files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportGroup implements SdkPojo, Serializable, ToCopyableBuilder<ReportGroup.Builder, ReportGroup> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReportGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReportGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReportGroup::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ReportExportConfig> EXPORT_CONFIG_FIELD = SdkField
            .<ReportExportConfig> builder(MarshallingType.SDK_POJO).getter(getter(ReportGroup::exportConfig))
            .setter(setter(Builder::exportConfig)).constructor(ReportExportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportConfig").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReportGroup::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReportGroup::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, EXPORT_CONFIG_FIELD, CREATED_FIELD, LAST_MODIFIED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final ReportExportConfig exportConfig;

    private final Instant created;

    private final Instant lastModified;

    private ReportGroup(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.exportConfig = builder.exportConfig;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
    }

    /**
     * <p>
     * The ARN of a <code>ReportGroup</code>.
     * </p>
     * 
     * @return The ARN of a <code>ReportGroup</code>.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of a <code>ReportGroup</code>.
     * </p>
     * 
     * @return The name of a <code>ReportGroup</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of the <code>ReportGroup</code>. The one valid value is <code>TEST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>ReportGroup</code>. The one valid value is <code>TEST</code>.
     * @see ReportType
     */
    public ReportType type() {
        return ReportType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>ReportGroup</code>. The one valid value is <code>TEST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>ReportGroup</code>. The one valid value is <code>TEST</code>.
     * @see ReportType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
     * </p>
     * 
     * @return Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
     */
    public ReportExportConfig exportConfig() {
        return exportConfig;
    }

    /**
     * <p>
     * The date and time this <code>ReportGroup</code> was created.
     * </p>
     * 
     * @return The date and time this <code>ReportGroup</code> was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The date and time this <code>ReportGroup</code> was last modified.
     * </p>
     * 
     * @return The date and time this <code>ReportGroup</code> was last modified.
     */
    public Instant lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportGroup)) {
            return false;
        }
        ReportGroup other = (ReportGroup) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(exportConfig(), other.exportConfig())
                && Objects.equals(created(), other.created()) && Objects.equals(lastModified(), other.lastModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReportGroup").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("ExportConfig", exportConfig()).add("Created", created()).add("LastModified", lastModified()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "exportConfig":
            return Optional.ofNullable(clazz.cast(exportConfig()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "lastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportGroup, T> g) {
        return obj -> g.apply((ReportGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportGroup> {
        /**
         * <p>
         * The ARN of a <code>ReportGroup</code>.
         * </p>
         * 
         * @param arn
         *        The ARN of a <code>ReportGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of a <code>ReportGroup</code>.
         * </p>
         * 
         * @param name
         *        The name of a <code>ReportGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the <code>ReportGroup</code>. The one valid value is <code>TEST</code>.
         * </p>
         * 
         * @param type
         *        The type of the <code>ReportGroup</code>. The one valid value is <code>TEST</code>.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>ReportGroup</code>. The one valid value is <code>TEST</code>.
         * </p>
         * 
         * @param type
         *        The type of the <code>ReportGroup</code>. The one valid value is <code>TEST</code>.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(ReportType type);

        /**
         * <p>
         * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
         * </p>
         * 
         * @param exportConfig
         *        Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportConfig(ReportExportConfig exportConfig);

        /**
         * <p>
         * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
         * </p>
         * This is a convenience that creates an instance of the {@link ReportExportConfig.Builder} avoiding the need to
         * create one manually via {@link ReportExportConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportExportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #exportConfig(ReportExportConfig)}.
         * 
         * @param exportConfig
         *        a consumer that will call methods on {@link ReportExportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportConfig(ReportExportConfig)
         */
        default Builder exportConfig(Consumer<ReportExportConfig.Builder> exportConfig) {
            return exportConfig(ReportExportConfig.builder().applyMutation(exportConfig).build());
        }

        /**
         * <p>
         * The date and time this <code>ReportGroup</code> was created.
         * </p>
         * 
         * @param created
         *        The date and time this <code>ReportGroup</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The date and time this <code>ReportGroup</code> was last modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time this <code>ReportGroup</code> was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private ReportExportConfig exportConfig;

        private Instant created;

        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportGroup model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            exportConfig(model.exportConfig);
            created(model.created);
            lastModified(model.lastModified);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReportType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ReportExportConfig.Builder getExportConfig() {
            return exportConfig != null ? exportConfig.toBuilder() : null;
        }

        @Override
        public final Builder exportConfig(ReportExportConfig exportConfig) {
            this.exportConfig = exportConfig;
            return this;
        }

        public final void setExportConfig(ReportExportConfig.BuilderImpl exportConfig) {
            this.exportConfig = exportConfig != null ? exportConfig.build() : null;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public ReportGroup build() {
            return new ReportGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
