/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an environment variable for a build project or a build.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentVariable implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentVariable.Builder, EnvironmentVariable> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnvironmentVariable::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnvironmentVariable::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnvironmentVariable::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private final String type;

    private EnvironmentVariable(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name or key of the environment variable.
     * </p>
     * 
     * @return The name or key of the environment variable.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value of the environment variable.
     * </p>
     * <important>
     * <p>
     * We strongly discourage the use of environment variables to store sensitive values, especially AWS secret key IDs
     * and secret access keys. Environment variables can be displayed in plain text using the AWS CodeBuild console and
     * the AWS Command Line Interface (AWS CLI).
     * </p>
     * </important>
     * 
     * @return The value of the environment variable.</p> <important>
     *         <p>
     *         We strongly discourage the use of environment variables to store sensitive values, especially AWS secret
     *         key IDs and secret access keys. Environment variables can be displayed in plain text using the AWS
     *         CodeBuild console and the AWS Command Line Interface (AWS CLI).
     *         </p>
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The type of environment variable. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PARAMETER_STORE</code>: An environment variable stored in Amazon EC2 Systems Manager Parameter Store.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAINTEXT</code>: An environment variable in plain text format. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SECRETS_MANAGER</code>: An environment variable stored in AWS Secrets Manager.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EnvironmentVariableType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of environment variable. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PARAMETER_STORE</code>: An environment variable stored in Amazon EC2 Systems Manager Parameter
     *         Store.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAINTEXT</code>: An environment variable in plain text format. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SECRETS_MANAGER</code>: An environment variable stored in AWS Secrets Manager.
     *         </p>
     *         </li>
     * @see EnvironmentVariableType
     */
    public EnvironmentVariableType type() {
        return EnvironmentVariableType.fromValue(type);
    }

    /**
     * <p>
     * The type of environment variable. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PARAMETER_STORE</code>: An environment variable stored in Amazon EC2 Systems Manager Parameter Store.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAINTEXT</code>: An environment variable in plain text format. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SECRETS_MANAGER</code>: An environment variable stored in AWS Secrets Manager.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EnvironmentVariableType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of environment variable. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PARAMETER_STORE</code>: An environment variable stored in Amazon EC2 Systems Manager Parameter
     *         Store.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAINTEXT</code>: An environment variable in plain text format. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SECRETS_MANAGER</code>: An environment variable stored in AWS Secrets Manager.
     *         </p>
     *         </li>
     * @see EnvironmentVariableType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentVariable)) {
            return false;
        }
        EnvironmentVariable other = (EnvironmentVariable) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnvironmentVariable").add("Name", name()).add("Value", value()).add("Type", typeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentVariable, T> g) {
        return obj -> g.apply((EnvironmentVariable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentVariable> {
        /**
         * <p>
         * The name or key of the environment variable.
         * </p>
         * 
         * @param name
         *        The name or key of the environment variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the environment variable.
         * </p>
         * <important>
         * <p>
         * We strongly discourage the use of environment variables to store sensitive values, especially AWS secret key
         * IDs and secret access keys. Environment variables can be displayed in plain text using the AWS CodeBuild
         * console and the AWS Command Line Interface (AWS CLI).
         * </p>
         * </important>
         * 
         * @param value
         *        The value of the environment variable.</p> <important>
         *        <p>
         *        We strongly discourage the use of environment variables to store sensitive values, especially AWS
         *        secret key IDs and secret access keys. Environment variables can be displayed in plain text using the
         *        AWS CodeBuild console and the AWS Command Line Interface (AWS CLI).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The type of environment variable. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PARAMETER_STORE</code>: An environment variable stored in Amazon EC2 Systems Manager Parameter Store.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAINTEXT</code>: An environment variable in plain text format. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SECRETS_MANAGER</code>: An environment variable stored in AWS Secrets Manager.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of environment variable. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PARAMETER_STORE</code>: An environment variable stored in Amazon EC2 Systems Manager Parameter
         *        Store.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAINTEXT</code>: An environment variable in plain text format. This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SECRETS_MANAGER</code>: An environment variable stored in AWS Secrets Manager.
         *        </p>
         *        </li>
         * @see EnvironmentVariableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentVariableType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of environment variable. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PARAMETER_STORE</code>: An environment variable stored in Amazon EC2 Systems Manager Parameter Store.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAINTEXT</code>: An environment variable in plain text format. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SECRETS_MANAGER</code>: An environment variable stored in AWS Secrets Manager.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of environment variable. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PARAMETER_STORE</code>: An environment variable stored in Amazon EC2 Systems Manager Parameter
         *        Store.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAINTEXT</code>: An environment variable in plain text format. This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SECRETS_MANAGER</code>: An environment variable stored in AWS Secrets Manager.
         *        </p>
         *        </li>
         * @see EnvironmentVariableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentVariableType
         */
        Builder type(EnvironmentVariableType type);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentVariable model) {
            name(model.name);
            value(model.value);
            type(model.type);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EnvironmentVariableType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public EnvironmentVariable build() {
            return new EnvironmentVariable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
