/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.model.GitSubmodulesConfig;
import software.amazon.awssdk.services.codebuild.model.ImagePullCredentialsType;
import software.amazon.awssdk.services.codebuild.model.LogsConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.RegistryCredential;
import software.amazon.awssdk.services.codebuild.model.SourceAuth;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBuildRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, StartBuildRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::projectName)).setter(StartBuildRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartBuildRequest.getter(StartBuildRequest::secondarySourcesOverride)).setter(StartBuildRequest.setter(Builder::secondarySourcesOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourcesOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartBuildRequest.getter(StartBuildRequest::secondarySourcesVersionOverride)).setter(StartBuildRequest.setter(Builder::secondarySourcesVersionOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourcesVersionOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSourceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::sourceVersion)).setter(StartBuildRequest.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<ProjectArtifacts> ARTIFACTS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartBuildRequest.getter(StartBuildRequest::artifactsOverride)).setter(StartBuildRequest.setter(Builder::artifactsOverride)).constructor(ProjectArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactsOverride").build()}).build();
    private static final SdkField<List<ProjectArtifacts>> SECONDARY_ARTIFACTS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartBuildRequest.getter(StartBuildRequest::secondaryArtifactsOverride)).setter(StartBuildRequest.setter(Builder::secondaryArtifactsOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifactsOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EnvironmentVariable>> ENVIRONMENT_VARIABLES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartBuildRequest.getter(StartBuildRequest::environmentVariablesOverride)).setter(StartBuildRequest.setter(Builder::environmentVariablesOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariablesOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_TYPE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::sourceTypeOverrideAsString)).setter(StartBuildRequest.setter(Builder::sourceTypeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTypeOverride").build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::sourceLocationOverride)).setter(StartBuildRequest.setter(Builder::sourceLocationOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLocationOverride").build()}).build();
    private static final SdkField<SourceAuth> SOURCE_AUTH_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartBuildRequest.getter(StartBuildRequest::sourceAuthOverride)).setter(StartBuildRequest.setter(Builder::sourceAuthOverride)).constructor(SourceAuth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAuthOverride").build()}).build();
    private static final SdkField<Integer> GIT_CLONE_DEPTH_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StartBuildRequest.getter(StartBuildRequest::gitCloneDepthOverride)).setter(StartBuildRequest.setter(Builder::gitCloneDepthOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitCloneDepthOverride").build()}).build();
    private static final SdkField<GitSubmodulesConfig> GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartBuildRequest.getter(StartBuildRequest::gitSubmodulesConfigOverride)).setter(StartBuildRequest.setter(Builder::gitSubmodulesConfigOverride)).constructor(GitSubmodulesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitSubmodulesConfigOverride").build()}).build();
    private static final SdkField<String> BUILDSPEC_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::buildspecOverride)).setter(StartBuildRequest.setter(Builder::buildspecOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildspecOverride").build()}).build();
    private static final SdkField<Boolean> INSECURE_SSL_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(StartBuildRequest.getter(StartBuildRequest::insecureSslOverride)).setter(StartBuildRequest.setter(Builder::insecureSslOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureSslOverride").build()}).build();
    private static final SdkField<Boolean> REPORT_BUILD_STATUS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(StartBuildRequest.getter(StartBuildRequest::reportBuildStatusOverride)).setter(StartBuildRequest.setter(Builder::reportBuildStatusOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportBuildStatusOverride").build()}).build();
    private static final SdkField<String> ENVIRONMENT_TYPE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::environmentTypeOverrideAsString)).setter(StartBuildRequest.setter(Builder::environmentTypeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTypeOverride").build()}).build();
    private static final SdkField<String> IMAGE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::imageOverride)).setter(StartBuildRequest.setter(Builder::imageOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageOverride").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::computeTypeOverrideAsString)).setter(StartBuildRequest.setter(Builder::computeTypeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeTypeOverride").build()}).build();
    private static final SdkField<String> CERTIFICATE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::certificateOverride)).setter(StartBuildRequest.setter(Builder::certificateOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateOverride").build()}).build();
    private static final SdkField<ProjectCache> CACHE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartBuildRequest.getter(StartBuildRequest::cacheOverride)).setter(StartBuildRequest.setter(Builder::cacheOverride)).constructor(ProjectCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheOverride").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::serviceRoleOverride)).setter(StartBuildRequest.setter(Builder::serviceRoleOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleOverride").build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_MODE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(StartBuildRequest.getter(StartBuildRequest::privilegedModeOverride)).setter(StartBuildRequest.setter(Builder::privilegedModeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privilegedModeOverride").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StartBuildRequest.getter(StartBuildRequest::timeoutInMinutesOverride)).setter(StartBuildRequest.setter(Builder::timeoutInMinutesOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutesOverride").build()}).build();
    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StartBuildRequest.getter(StartBuildRequest::queuedTimeoutInMinutesOverride)).setter(StartBuildRequest.setter(Builder::queuedTimeoutInMinutesOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutesOverride").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::idempotencyToken)).setter(StartBuildRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idempotencyToken").build()}).build();
    private static final SdkField<LogsConfig> LOGS_CONFIG_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartBuildRequest.getter(StartBuildRequest::logsConfigOverride)).setter(StartBuildRequest.setter(Builder::logsConfigOverride)).constructor(LogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsConfigOverride").build()}).build();
    private static final SdkField<RegistryCredential> REGISTRY_CREDENTIAL_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartBuildRequest.getter(StartBuildRequest::registryCredentialOverride)).setter(StartBuildRequest.setter(Builder::registryCredentialOverride)).constructor(RegistryCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryCredentialOverride").build()}).build();
    private static final SdkField<String> IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBuildRequest.getter(StartBuildRequest::imagePullCredentialsTypeOverrideAsString)).setter(StartBuildRequest.setter(Builder::imagePullCredentialsTypeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePullCredentialsTypeOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, SECONDARY_SOURCES_OVERRIDE_FIELD, SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD, SOURCE_VERSION_FIELD, ARTIFACTS_OVERRIDE_FIELD, SECONDARY_ARTIFACTS_OVERRIDE_FIELD, ENVIRONMENT_VARIABLES_OVERRIDE_FIELD, SOURCE_TYPE_OVERRIDE_FIELD, SOURCE_LOCATION_OVERRIDE_FIELD, SOURCE_AUTH_OVERRIDE_FIELD, GIT_CLONE_DEPTH_OVERRIDE_FIELD, GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD, BUILDSPEC_OVERRIDE_FIELD, INSECURE_SSL_OVERRIDE_FIELD, REPORT_BUILD_STATUS_OVERRIDE_FIELD, ENVIRONMENT_TYPE_OVERRIDE_FIELD, IMAGE_OVERRIDE_FIELD, COMPUTE_TYPE_OVERRIDE_FIELD, CERTIFICATE_OVERRIDE_FIELD, CACHE_OVERRIDE_FIELD, SERVICE_ROLE_OVERRIDE_FIELD, PRIVILEGED_MODE_OVERRIDE_FIELD, TIMEOUT_IN_MINUTES_OVERRIDE_FIELD, QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD, IDEMPOTENCY_TOKEN_FIELD, LOGS_CONFIG_OVERRIDE_FIELD, REGISTRY_CREDENTIAL_OVERRIDE_FIELD, IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD));
    private final String projectName;
    private final List<ProjectSource> secondarySourcesOverride;
    private final List<ProjectSourceVersion> secondarySourcesVersionOverride;
    private final String sourceVersion;
    private final ProjectArtifacts artifactsOverride;
    private final List<ProjectArtifacts> secondaryArtifactsOverride;
    private final List<EnvironmentVariable> environmentVariablesOverride;
    private final String sourceTypeOverride;
    private final String sourceLocationOverride;
    private final SourceAuth sourceAuthOverride;
    private final Integer gitCloneDepthOverride;
    private final GitSubmodulesConfig gitSubmodulesConfigOverride;
    private final String buildspecOverride;
    private final Boolean insecureSslOverride;
    private final Boolean reportBuildStatusOverride;
    private final String environmentTypeOverride;
    private final String imageOverride;
    private final String computeTypeOverride;
    private final String certificateOverride;
    private final ProjectCache cacheOverride;
    private final String serviceRoleOverride;
    private final Boolean privilegedModeOverride;
    private final Integer timeoutInMinutesOverride;
    private final Integer queuedTimeoutInMinutesOverride;
    private final String idempotencyToken;
    private final LogsConfig logsConfigOverride;
    private final RegistryCredential registryCredentialOverride;
    private final String imagePullCredentialsTypeOverride;

    private StartBuildRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.secondarySourcesOverride = builder.secondarySourcesOverride;
        this.secondarySourcesVersionOverride = builder.secondarySourcesVersionOverride;
        this.sourceVersion = builder.sourceVersion;
        this.artifactsOverride = builder.artifactsOverride;
        this.secondaryArtifactsOverride = builder.secondaryArtifactsOverride;
        this.environmentVariablesOverride = builder.environmentVariablesOverride;
        this.sourceTypeOverride = builder.sourceTypeOverride;
        this.sourceLocationOverride = builder.sourceLocationOverride;
        this.sourceAuthOverride = builder.sourceAuthOverride;
        this.gitCloneDepthOverride = builder.gitCloneDepthOverride;
        this.gitSubmodulesConfigOverride = builder.gitSubmodulesConfigOverride;
        this.buildspecOverride = builder.buildspecOverride;
        this.insecureSslOverride = builder.insecureSslOverride;
        this.reportBuildStatusOverride = builder.reportBuildStatusOverride;
        this.environmentTypeOverride = builder.environmentTypeOverride;
        this.imageOverride = builder.imageOverride;
        this.computeTypeOverride = builder.computeTypeOverride;
        this.certificateOverride = builder.certificateOverride;
        this.cacheOverride = builder.cacheOverride;
        this.serviceRoleOverride = builder.serviceRoleOverride;
        this.privilegedModeOverride = builder.privilegedModeOverride;
        this.timeoutInMinutesOverride = builder.timeoutInMinutesOverride;
        this.queuedTimeoutInMinutesOverride = builder.queuedTimeoutInMinutesOverride;
        this.idempotencyToken = builder.idempotencyToken;
        this.logsConfigOverride = builder.logsConfigOverride;
        this.registryCredentialOverride = builder.registryCredentialOverride;
        this.imagePullCredentialsTypeOverride = builder.imagePullCredentialsTypeOverride;
    }

    public String projectName() {
        return this.projectName;
    }

    public boolean hasSecondarySourcesOverride() {
        return this.secondarySourcesOverride != null && !(this.secondarySourcesOverride instanceof SdkAutoConstructList);
    }

    public List<ProjectSource> secondarySourcesOverride() {
        return this.secondarySourcesOverride;
    }

    public boolean hasSecondarySourcesVersionOverride() {
        return this.secondarySourcesVersionOverride != null && !(this.secondarySourcesVersionOverride instanceof SdkAutoConstructList);
    }

    public List<ProjectSourceVersion> secondarySourcesVersionOverride() {
        return this.secondarySourcesVersionOverride;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public ProjectArtifacts artifactsOverride() {
        return this.artifactsOverride;
    }

    public boolean hasSecondaryArtifactsOverride() {
        return this.secondaryArtifactsOverride != null && !(this.secondaryArtifactsOverride instanceof SdkAutoConstructList);
    }

    public List<ProjectArtifacts> secondaryArtifactsOverride() {
        return this.secondaryArtifactsOverride;
    }

    public boolean hasEnvironmentVariablesOverride() {
        return this.environmentVariablesOverride != null && !(this.environmentVariablesOverride instanceof SdkAutoConstructList);
    }

    public List<EnvironmentVariable> environmentVariablesOverride() {
        return this.environmentVariablesOverride;
    }

    public SourceType sourceTypeOverride() {
        return SourceType.fromValue(this.sourceTypeOverride);
    }

    public String sourceTypeOverrideAsString() {
        return this.sourceTypeOverride;
    }

    public String sourceLocationOverride() {
        return this.sourceLocationOverride;
    }

    public SourceAuth sourceAuthOverride() {
        return this.sourceAuthOverride;
    }

    public Integer gitCloneDepthOverride() {
        return this.gitCloneDepthOverride;
    }

    public GitSubmodulesConfig gitSubmodulesConfigOverride() {
        return this.gitSubmodulesConfigOverride;
    }

    public String buildspecOverride() {
        return this.buildspecOverride;
    }

    public Boolean insecureSslOverride() {
        return this.insecureSslOverride;
    }

    public Boolean reportBuildStatusOverride() {
        return this.reportBuildStatusOverride;
    }

    public EnvironmentType environmentTypeOverride() {
        return EnvironmentType.fromValue(this.environmentTypeOverride);
    }

    public String environmentTypeOverrideAsString() {
        return this.environmentTypeOverride;
    }

    public String imageOverride() {
        return this.imageOverride;
    }

    public ComputeType computeTypeOverride() {
        return ComputeType.fromValue(this.computeTypeOverride);
    }

    public String computeTypeOverrideAsString() {
        return this.computeTypeOverride;
    }

    public String certificateOverride() {
        return this.certificateOverride;
    }

    public ProjectCache cacheOverride() {
        return this.cacheOverride;
    }

    public String serviceRoleOverride() {
        return this.serviceRoleOverride;
    }

    public Boolean privilegedModeOverride() {
        return this.privilegedModeOverride;
    }

    public Integer timeoutInMinutesOverride() {
        return this.timeoutInMinutesOverride;
    }

    public Integer queuedTimeoutInMinutesOverride() {
        return this.queuedTimeoutInMinutesOverride;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public LogsConfig logsConfigOverride() {
        return this.logsConfigOverride;
    }

    public RegistryCredential registryCredentialOverride() {
        return this.registryCredentialOverride;
    }

    public ImagePullCredentialsType imagePullCredentialsTypeOverride() {
        return ImagePullCredentialsType.fromValue(this.imagePullCredentialsTypeOverride);
    }

    public String imagePullCredentialsTypeOverrideAsString() {
        return this.imagePullCredentialsTypeOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySourcesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySourcesVersionOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryArtifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentVariablesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAuthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitCloneDepthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitSubmodulesConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildspecOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.insecureSslOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportBuildStatusOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.privilegedModeOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedTimeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryCredentialOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePullCredentialsTypeOverrideAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBuildRequest)) {
            return false;
        }
        StartBuildRequest other = (StartBuildRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.secondarySourcesOverride(), other.secondarySourcesOverride()) && Objects.equals(this.secondarySourcesVersionOverride(), other.secondarySourcesVersionOverride()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.artifactsOverride(), other.artifactsOverride()) && Objects.equals(this.secondaryArtifactsOverride(), other.secondaryArtifactsOverride()) && Objects.equals(this.environmentVariablesOverride(), other.environmentVariablesOverride()) && Objects.equals(this.sourceTypeOverrideAsString(), other.sourceTypeOverrideAsString()) && Objects.equals(this.sourceLocationOverride(), other.sourceLocationOverride()) && Objects.equals(this.sourceAuthOverride(), other.sourceAuthOverride()) && Objects.equals(this.gitCloneDepthOverride(), other.gitCloneDepthOverride()) && Objects.equals(this.gitSubmodulesConfigOverride(), other.gitSubmodulesConfigOverride()) && Objects.equals(this.buildspecOverride(), other.buildspecOverride()) && Objects.equals(this.insecureSslOverride(), other.insecureSslOverride()) && Objects.equals(this.reportBuildStatusOverride(), other.reportBuildStatusOverride()) && Objects.equals(this.environmentTypeOverrideAsString(), other.environmentTypeOverrideAsString()) && Objects.equals(this.imageOverride(), other.imageOverride()) && Objects.equals(this.computeTypeOverrideAsString(), other.computeTypeOverrideAsString()) && Objects.equals(this.certificateOverride(), other.certificateOverride()) && Objects.equals(this.cacheOverride(), other.cacheOverride()) && Objects.equals(this.serviceRoleOverride(), other.serviceRoleOverride()) && Objects.equals(this.privilegedModeOverride(), other.privilegedModeOverride()) && Objects.equals(this.timeoutInMinutesOverride(), other.timeoutInMinutesOverride()) && Objects.equals(this.queuedTimeoutInMinutesOverride(), other.queuedTimeoutInMinutesOverride()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.logsConfigOverride(), other.logsConfigOverride()) && Objects.equals(this.registryCredentialOverride(), other.registryCredentialOverride()) && Objects.equals(this.imagePullCredentialsTypeOverrideAsString(), other.imagePullCredentialsTypeOverrideAsString());
    }

    public String toString() {
        return ToString.builder((String)"StartBuildRequest").add("ProjectName", (Object)this.projectName()).add("SecondarySourcesOverride", this.secondarySourcesOverride()).add("SecondarySourcesVersionOverride", this.secondarySourcesVersionOverride()).add("SourceVersion", (Object)this.sourceVersion()).add("ArtifactsOverride", (Object)this.artifactsOverride()).add("SecondaryArtifactsOverride", this.secondaryArtifactsOverride()).add("EnvironmentVariablesOverride", this.environmentVariablesOverride()).add("SourceTypeOverride", (Object)this.sourceTypeOverrideAsString()).add("SourceLocationOverride", (Object)this.sourceLocationOverride()).add("SourceAuthOverride", (Object)this.sourceAuthOverride()).add("GitCloneDepthOverride", (Object)this.gitCloneDepthOverride()).add("GitSubmodulesConfigOverride", (Object)this.gitSubmodulesConfigOverride()).add("BuildspecOverride", (Object)this.buildspecOverride()).add("InsecureSslOverride", (Object)this.insecureSslOverride()).add("ReportBuildStatusOverride", (Object)this.reportBuildStatusOverride()).add("EnvironmentTypeOverride", (Object)this.environmentTypeOverrideAsString()).add("ImageOverride", (Object)this.imageOverride()).add("ComputeTypeOverride", (Object)this.computeTypeOverrideAsString()).add("CertificateOverride", (Object)this.certificateOverride()).add("CacheOverride", (Object)this.cacheOverride()).add("ServiceRoleOverride", (Object)this.serviceRoleOverride()).add("PrivilegedModeOverride", (Object)this.privilegedModeOverride()).add("TimeoutInMinutesOverride", (Object)this.timeoutInMinutesOverride()).add("QueuedTimeoutInMinutesOverride", (Object)this.queuedTimeoutInMinutesOverride()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("LogsConfigOverride", (Object)this.logsConfigOverride()).add("RegistryCredentialOverride", (Object)this.registryCredentialOverride()).add("ImagePullCredentialsTypeOverride", (Object)this.imagePullCredentialsTypeOverrideAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "secondarySourcesOverride": {
                return Optional.ofNullable(clazz.cast(this.secondarySourcesOverride()));
            }
            case "secondarySourcesVersionOverride": {
                return Optional.ofNullable(clazz.cast(this.secondarySourcesVersionOverride()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "artifactsOverride": {
                return Optional.ofNullable(clazz.cast(this.artifactsOverride()));
            }
            case "secondaryArtifactsOverride": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifactsOverride()));
            }
            case "environmentVariablesOverride": {
                return Optional.ofNullable(clazz.cast(this.environmentVariablesOverride()));
            }
            case "sourceTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeOverrideAsString()));
            }
            case "sourceLocationOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationOverride()));
            }
            case "sourceAuthOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceAuthOverride()));
            }
            case "gitCloneDepthOverride": {
                return Optional.ofNullable(clazz.cast(this.gitCloneDepthOverride()));
            }
            case "gitSubmodulesConfigOverride": {
                return Optional.ofNullable(clazz.cast(this.gitSubmodulesConfigOverride()));
            }
            case "buildspecOverride": {
                return Optional.ofNullable(clazz.cast(this.buildspecOverride()));
            }
            case "insecureSslOverride": {
                return Optional.ofNullable(clazz.cast(this.insecureSslOverride()));
            }
            case "reportBuildStatusOverride": {
                return Optional.ofNullable(clazz.cast(this.reportBuildStatusOverride()));
            }
            case "environmentTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.environmentTypeOverrideAsString()));
            }
            case "imageOverride": {
                return Optional.ofNullable(clazz.cast(this.imageOverride()));
            }
            case "computeTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.computeTypeOverrideAsString()));
            }
            case "certificateOverride": {
                return Optional.ofNullable(clazz.cast(this.certificateOverride()));
            }
            case "cacheOverride": {
                return Optional.ofNullable(clazz.cast(this.cacheOverride()));
            }
            case "serviceRoleOverride": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleOverride()));
            }
            case "privilegedModeOverride": {
                return Optional.ofNullable(clazz.cast(this.privilegedModeOverride()));
            }
            case "timeoutInMinutesOverride": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutesOverride()));
            }
            case "queuedTimeoutInMinutesOverride": {
                return Optional.ofNullable(clazz.cast(this.queuedTimeoutInMinutesOverride()));
            }
            case "idempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "logsConfigOverride": {
                return Optional.ofNullable(clazz.cast(this.logsConfigOverride()));
            }
            case "registryCredentialOverride": {
                return Optional.ofNullable(clazz.cast(this.registryCredentialOverride()));
            }
            case "imagePullCredentialsTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.imagePullCredentialsTypeOverrideAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBuildRequest, T> g) {
        return obj -> g.apply((StartBuildRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private List<ProjectSource> secondarySourcesOverride = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectSourceVersion> secondarySourcesVersionOverride = DefaultSdkAutoConstructList.getInstance();
        private String sourceVersion;
        private ProjectArtifacts artifactsOverride;
        private List<ProjectArtifacts> secondaryArtifactsOverride = DefaultSdkAutoConstructList.getInstance();
        private List<EnvironmentVariable> environmentVariablesOverride = DefaultSdkAutoConstructList.getInstance();
        private String sourceTypeOverride;
        private String sourceLocationOverride;
        private SourceAuth sourceAuthOverride;
        private Integer gitCloneDepthOverride;
        private GitSubmodulesConfig gitSubmodulesConfigOverride;
        private String buildspecOverride;
        private Boolean insecureSslOverride;
        private Boolean reportBuildStatusOverride;
        private String environmentTypeOverride;
        private String imageOverride;
        private String computeTypeOverride;
        private String certificateOverride;
        private ProjectCache cacheOverride;
        private String serviceRoleOverride;
        private Boolean privilegedModeOverride;
        private Integer timeoutInMinutesOverride;
        private Integer queuedTimeoutInMinutesOverride;
        private String idempotencyToken;
        private LogsConfig logsConfigOverride;
        private RegistryCredential registryCredentialOverride;
        private String imagePullCredentialsTypeOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBuildRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.secondarySourcesOverride(model.secondarySourcesOverride);
            this.secondarySourcesVersionOverride(model.secondarySourcesVersionOverride);
            this.sourceVersion(model.sourceVersion);
            this.artifactsOverride(model.artifactsOverride);
            this.secondaryArtifactsOverride(model.secondaryArtifactsOverride);
            this.environmentVariablesOverride(model.environmentVariablesOverride);
            this.sourceTypeOverride(model.sourceTypeOverride);
            this.sourceLocationOverride(model.sourceLocationOverride);
            this.sourceAuthOverride(model.sourceAuthOverride);
            this.gitCloneDepthOverride(model.gitCloneDepthOverride);
            this.gitSubmodulesConfigOverride(model.gitSubmodulesConfigOverride);
            this.buildspecOverride(model.buildspecOverride);
            this.insecureSslOverride(model.insecureSslOverride);
            this.reportBuildStatusOverride(model.reportBuildStatusOverride);
            this.environmentTypeOverride(model.environmentTypeOverride);
            this.imageOverride(model.imageOverride);
            this.computeTypeOverride(model.computeTypeOverride);
            this.certificateOverride(model.certificateOverride);
            this.cacheOverride(model.cacheOverride);
            this.serviceRoleOverride(model.serviceRoleOverride);
            this.privilegedModeOverride(model.privilegedModeOverride);
            this.timeoutInMinutesOverride(model.timeoutInMinutesOverride);
            this.queuedTimeoutInMinutesOverride(model.queuedTimeoutInMinutesOverride);
            this.idempotencyToken(model.idempotencyToken);
            this.logsConfigOverride(model.logsConfigOverride);
            this.registryCredentialOverride(model.registryCredentialOverride);
            this.imagePullCredentialsTypeOverride(model.imagePullCredentialsTypeOverride);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Collection<ProjectSource.Builder> getSecondarySourcesOverride() {
            return this.secondarySourcesOverride != null ? (Collection)this.secondarySourcesOverride.stream().map(ProjectSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySourcesOverride(Collection<ProjectSource> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copy(secondarySourcesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(ProjectSource ... secondarySourcesOverride) {
            this.secondarySourcesOverride(Arrays.asList(secondarySourcesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(Consumer<ProjectSource.Builder> ... secondarySourcesOverride) {
            this.secondarySourcesOverride(Stream.of(secondarySourcesOverride).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySourcesOverride(Collection<ProjectSource.BuilderImpl> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copyFromBuilder(secondarySourcesOverride);
        }

        public final Collection<ProjectSourceVersion.Builder> getSecondarySourcesVersionOverride() {
            return this.secondarySourcesVersionOverride != null ? (Collection)this.secondarySourcesVersionOverride.stream().map(ProjectSourceVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier.copy(secondarySourcesVersionOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(ProjectSourceVersion ... secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride(Arrays.asList(secondarySourcesVersionOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(Consumer<ProjectSourceVersion.Builder> ... secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride(Stream.of(secondarySourcesVersionOverride).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySourcesVersionOverride(Collection<ProjectSourceVersion.BuilderImpl> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourcesVersionOverride);
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final ProjectArtifacts.Builder getArtifactsOverride() {
            return this.artifactsOverride != null ? this.artifactsOverride.toBuilder() : null;
        }

        @Override
        public final Builder artifactsOverride(ProjectArtifacts artifactsOverride) {
            this.artifactsOverride = artifactsOverride;
            return this;
        }

        public final void setArtifactsOverride(ProjectArtifacts.BuilderImpl artifactsOverride) {
            this.artifactsOverride = artifactsOverride != null ? artifactsOverride.build() : null;
        }

        public final Collection<ProjectArtifacts.Builder> getSecondaryArtifactsOverride() {
            return this.secondaryArtifactsOverride != null ? (Collection)this.secondaryArtifactsOverride.stream().map(ProjectArtifacts::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copy(secondaryArtifactsOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(ProjectArtifacts ... secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride(Arrays.asList(secondaryArtifactsOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder> ... secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride(Stream.of(secondaryArtifactsOverride).map(c -> (ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryArtifactsOverride(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifactsOverride);
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironmentVariablesOverride() {
            return this.environmentVariablesOverride != null ? (Collection)this.environmentVariablesOverride.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copy(environmentVariablesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(EnvironmentVariable ... environmentVariablesOverride) {
            this.environmentVariablesOverride(Arrays.asList(environmentVariablesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder> ... environmentVariablesOverride) {
            this.environmentVariablesOverride(Stream.of(environmentVariablesOverride).map(c -> (EnvironmentVariable)((EnvironmentVariable.Builder)EnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentVariablesOverride(Collection<EnvironmentVariable.BuilderImpl> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copyFromBuilder(environmentVariablesOverride);
        }

        public final String getSourceTypeOverrideAsString() {
            return this.sourceTypeOverride;
        }

        @Override
        public final Builder sourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
            return this;
        }

        @Override
        public final Builder sourceTypeOverride(SourceType sourceTypeOverride) {
            this.sourceTypeOverride(sourceTypeOverride == null ? null : sourceTypeOverride.toString());
            return this;
        }

        public final void setSourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
        }

        public final String getSourceLocationOverride() {
            return this.sourceLocationOverride;
        }

        @Override
        public final Builder sourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
            return this;
        }

        public final void setSourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
        }

        public final SourceAuth.Builder getSourceAuthOverride() {
            return this.sourceAuthOverride != null ? this.sourceAuthOverride.toBuilder() : null;
        }

        @Override
        public final Builder sourceAuthOverride(SourceAuth sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride;
            return this;
        }

        public final void setSourceAuthOverride(SourceAuth.BuilderImpl sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride != null ? sourceAuthOverride.build() : null;
        }

        public final Integer getGitCloneDepthOverride() {
            return this.gitCloneDepthOverride;
        }

        @Override
        public final Builder gitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
            return this;
        }

        public final void setGitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
        }

        public final GitSubmodulesConfig.Builder getGitSubmodulesConfigOverride() {
            return this.gitSubmodulesConfigOverride != null ? this.gitSubmodulesConfigOverride.toBuilder() : null;
        }

        @Override
        public final Builder gitSubmodulesConfigOverride(GitSubmodulesConfig gitSubmodulesConfigOverride) {
            this.gitSubmodulesConfigOverride = gitSubmodulesConfigOverride;
            return this;
        }

        public final void setGitSubmodulesConfigOverride(GitSubmodulesConfig.BuilderImpl gitSubmodulesConfigOverride) {
            this.gitSubmodulesConfigOverride = gitSubmodulesConfigOverride != null ? gitSubmodulesConfigOverride.build() : null;
        }

        public final String getBuildspecOverride() {
            return this.buildspecOverride;
        }

        @Override
        public final Builder buildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
            return this;
        }

        public final void setBuildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
        }

        public final Boolean getInsecureSslOverride() {
            return this.insecureSslOverride;
        }

        @Override
        public final Builder insecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
            return this;
        }

        public final void setInsecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
        }

        public final Boolean getReportBuildStatusOverride() {
            return this.reportBuildStatusOverride;
        }

        @Override
        public final Builder reportBuildStatusOverride(Boolean reportBuildStatusOverride) {
            this.reportBuildStatusOverride = reportBuildStatusOverride;
            return this;
        }

        public final void setReportBuildStatusOverride(Boolean reportBuildStatusOverride) {
            this.reportBuildStatusOverride = reportBuildStatusOverride;
        }

        public final String getEnvironmentTypeOverrideAsString() {
            return this.environmentTypeOverride;
        }

        @Override
        public final Builder environmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
            return this;
        }

        @Override
        public final Builder environmentTypeOverride(EnvironmentType environmentTypeOverride) {
            this.environmentTypeOverride(environmentTypeOverride == null ? null : environmentTypeOverride.toString());
            return this;
        }

        public final void setEnvironmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
        }

        public final String getImageOverride() {
            return this.imageOverride;
        }

        @Override
        public final Builder imageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
            return this;
        }

        public final void setImageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
        }

        public final String getComputeTypeOverrideAsString() {
            return this.computeTypeOverride;
        }

        @Override
        public final Builder computeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
            return this;
        }

        @Override
        public final Builder computeTypeOverride(ComputeType computeTypeOverride) {
            this.computeTypeOverride(computeTypeOverride == null ? null : computeTypeOverride.toString());
            return this;
        }

        public final void setComputeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
        }

        public final String getCertificateOverride() {
            return this.certificateOverride;
        }

        @Override
        public final Builder certificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
            return this;
        }

        public final void setCertificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
        }

        public final ProjectCache.Builder getCacheOverride() {
            return this.cacheOverride != null ? this.cacheOverride.toBuilder() : null;
        }

        @Override
        public final Builder cacheOverride(ProjectCache cacheOverride) {
            this.cacheOverride = cacheOverride;
            return this;
        }

        public final void setCacheOverride(ProjectCache.BuilderImpl cacheOverride) {
            this.cacheOverride = cacheOverride != null ? cacheOverride.build() : null;
        }

        public final String getServiceRoleOverride() {
            return this.serviceRoleOverride;
        }

        @Override
        public final Builder serviceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
            return this;
        }

        public final void setServiceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
        }

        public final Boolean getPrivilegedModeOverride() {
            return this.privilegedModeOverride;
        }

        @Override
        public final Builder privilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
            return this;
        }

        public final void setPrivilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
        }

        public final Integer getTimeoutInMinutesOverride() {
            return this.timeoutInMinutesOverride;
        }

        @Override
        public final Builder timeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
            return this;
        }

        public final void setTimeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
        }

        public final Integer getQueuedTimeoutInMinutesOverride() {
            return this.queuedTimeoutInMinutesOverride;
        }

        @Override
        public final Builder queuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride) {
            this.queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride;
            return this;
        }

        public final void setQueuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride) {
            this.queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final LogsConfig.Builder getLogsConfigOverride() {
            return this.logsConfigOverride != null ? this.logsConfigOverride.toBuilder() : null;
        }

        @Override
        public final Builder logsConfigOverride(LogsConfig logsConfigOverride) {
            this.logsConfigOverride = logsConfigOverride;
            return this;
        }

        public final void setLogsConfigOverride(LogsConfig.BuilderImpl logsConfigOverride) {
            this.logsConfigOverride = logsConfigOverride != null ? logsConfigOverride.build() : null;
        }

        public final RegistryCredential.Builder getRegistryCredentialOverride() {
            return this.registryCredentialOverride != null ? this.registryCredentialOverride.toBuilder() : null;
        }

        @Override
        public final Builder registryCredentialOverride(RegistryCredential registryCredentialOverride) {
            this.registryCredentialOverride = registryCredentialOverride;
            return this;
        }

        public final void setRegistryCredentialOverride(RegistryCredential.BuilderImpl registryCredentialOverride) {
            this.registryCredentialOverride = registryCredentialOverride != null ? registryCredentialOverride.build() : null;
        }

        public final String getImagePullCredentialsTypeOverrideAsString() {
            return this.imagePullCredentialsTypeOverride;
        }

        @Override
        public final Builder imagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride;
            return this;
        }

        @Override
        public final Builder imagePullCredentialsTypeOverride(ImagePullCredentialsType imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride(imagePullCredentialsTypeOverride == null ? null : imagePullCredentialsTypeOverride.toString());
            return this;
        }

        public final void setImagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBuildRequest build() {
            return new StartBuildRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBuildRequest> {
        public Builder projectName(String var1);

        public Builder secondarySourcesOverride(Collection<ProjectSource> var1);

        public Builder secondarySourcesOverride(ProjectSource ... var1);

        public Builder secondarySourcesOverride(Consumer<ProjectSource.Builder> ... var1);

        public Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourcesVersionOverride(ProjectSourceVersion ... var1);

        public Builder secondarySourcesVersionOverride(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder sourceVersion(String var1);

        public Builder artifactsOverride(ProjectArtifacts var1);

        default public Builder artifactsOverride(Consumer<ProjectArtifacts.Builder> artifactsOverride) {
            return this.artifactsOverride((ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation(artifactsOverride)).build());
        }

        public Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> var1);

        public Builder secondaryArtifactsOverride(ProjectArtifacts ... var1);

        public Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder> ... var1);

        public Builder environmentVariablesOverride(Collection<EnvironmentVariable> var1);

        public Builder environmentVariablesOverride(EnvironmentVariable ... var1);

        public Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder> ... var1);

        public Builder sourceTypeOverride(String var1);

        public Builder sourceTypeOverride(SourceType var1);

        public Builder sourceLocationOverride(String var1);

        public Builder sourceAuthOverride(SourceAuth var1);

        default public Builder sourceAuthOverride(Consumer<SourceAuth.Builder> sourceAuthOverride) {
            return this.sourceAuthOverride((SourceAuth)((SourceAuth.Builder)SourceAuth.builder().applyMutation(sourceAuthOverride)).build());
        }

        public Builder gitCloneDepthOverride(Integer var1);

        public Builder gitSubmodulesConfigOverride(GitSubmodulesConfig var1);

        default public Builder gitSubmodulesConfigOverride(Consumer<GitSubmodulesConfig.Builder> gitSubmodulesConfigOverride) {
            return this.gitSubmodulesConfigOverride((GitSubmodulesConfig)((GitSubmodulesConfig.Builder)GitSubmodulesConfig.builder().applyMutation(gitSubmodulesConfigOverride)).build());
        }

        public Builder buildspecOverride(String var1);

        public Builder insecureSslOverride(Boolean var1);

        public Builder reportBuildStatusOverride(Boolean var1);

        public Builder environmentTypeOverride(String var1);

        public Builder environmentTypeOverride(EnvironmentType var1);

        public Builder imageOverride(String var1);

        public Builder computeTypeOverride(String var1);

        public Builder computeTypeOverride(ComputeType var1);

        public Builder certificateOverride(String var1);

        public Builder cacheOverride(ProjectCache var1);

        default public Builder cacheOverride(Consumer<ProjectCache.Builder> cacheOverride) {
            return this.cacheOverride((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cacheOverride)).build());
        }

        public Builder serviceRoleOverride(String var1);

        public Builder privilegedModeOverride(Boolean var1);

        public Builder timeoutInMinutesOverride(Integer var1);

        public Builder queuedTimeoutInMinutesOverride(Integer var1);

        public Builder idempotencyToken(String var1);

        public Builder logsConfigOverride(LogsConfig var1);

        default public Builder logsConfigOverride(Consumer<LogsConfig.Builder> logsConfigOverride) {
            return this.logsConfigOverride((LogsConfig)((LogsConfig.Builder)LogsConfig.builder().applyMutation(logsConfigOverride)).build());
        }

        public Builder registryCredentialOverride(RegistryCredential var1);

        default public Builder registryCredentialOverride(Consumer<RegistryCredential.Builder> registryCredentialOverride) {
            return this.registryCredentialOverride((RegistryCredential)((RegistryCredential.Builder)RegistryCredential.builder().applyMutation(registryCredentialOverride)).build());
        }

        public Builder imagePullCredentialsTypeOverride(String var1);

        public Builder imagePullCredentialsTypeOverride(ImagePullCredentialsType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

