/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.ReportPackagingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ReportExportConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ReportExportConfig> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ReportExportConfig.getter(S3ReportExportConfig::bucket)).setter(S3ReportExportConfig.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ReportExportConfig.getter(S3ReportExportConfig::path)).setter(S3ReportExportConfig.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> PACKAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ReportExportConfig.getter(S3ReportExportConfig::packagingAsString)).setter(S3ReportExportConfig.setter(Builder::packaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packaging").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ReportExportConfig.getter(S3ReportExportConfig::encryptionKey)).setter(S3ReportExportConfig.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(S3ReportExportConfig.getter(S3ReportExportConfig::encryptionDisabled)).setter(S3ReportExportConfig.setter(Builder::encryptionDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDisabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, PATH_FIELD, PACKAGING_FIELD, ENCRYPTION_KEY_FIELD, ENCRYPTION_DISABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String path;
    private final String packaging;
    private final String encryptionKey;
    private final Boolean encryptionDisabled;

    private S3ReportExportConfig(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.path = builder.path;
        this.packaging = builder.packaging;
        this.encryptionKey = builder.encryptionKey;
        this.encryptionDisabled = builder.encryptionDisabled;
    }

    public String bucket() {
        return this.bucket;
    }

    public String path() {
        return this.path;
    }

    public ReportPackagingType packaging() {
        return ReportPackagingType.fromValue(this.packaging);
    }

    public String packagingAsString() {
        return this.packaging;
    }

    public String encryptionKey() {
        return this.encryptionKey;
    }

    public Boolean encryptionDisabled() {
        return this.encryptionDisabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionDisabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReportExportConfig)) {
            return false;
        }
        S3ReportExportConfig other = (S3ReportExportConfig)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.packagingAsString(), other.packagingAsString()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.encryptionDisabled(), other.encryptionDisabled());
    }

    public String toString() {
        return ToString.builder((String)"S3ReportExportConfig").add("Bucket", (Object)this.bucket()).add("Path", (Object)this.path()).add("Packaging", (Object)this.packagingAsString()).add("EncryptionKey", (Object)this.encryptionKey()).add("EncryptionDisabled", (Object)this.encryptionDisabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "packaging": {
                return Optional.ofNullable(clazz.cast(this.packagingAsString()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "encryptionDisabled": {
                return Optional.ofNullable(clazz.cast(this.encryptionDisabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ReportExportConfig, T> g) {
        return obj -> g.apply((S3ReportExportConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String path;
        private String packaging;
        private String encryptionKey;
        private Boolean encryptionDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReportExportConfig model) {
            this.bucket(model.bucket);
            this.path(model.path);
            this.packaging(model.packaging);
            this.encryptionKey(model.encryptionKey);
            this.encryptionDisabled(model.encryptionDisabled);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getPackagingAsString() {
            return this.packaging;
        }

        @Override
        public final Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Override
        public final Builder packaging(ReportPackagingType packaging) {
            this.packaging(packaging == null ? null : packaging.toString());
            return this;
        }

        public final void setPackaging(String packaging) {
            this.packaging = packaging;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final Boolean getEncryptionDisabled() {
            return this.encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        public S3ReportExportConfig build() {
            return new S3ReportExportConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ReportExportConfig> {
        public Builder bucket(String var1);

        public Builder path(String var1);

        public Builder packaging(String var1);

        public Builder packaging(ReportPackagingType var1);

        public Builder encryptionKey(String var1);

        public Builder encryptionDisabled(Boolean var1);
    }
}

