/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBuildsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, ListBuildsResponse> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListBuildsResponse.getter(ListBuildsResponse::ids)).setter(ListBuildsResponse.setter(Builder::ids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBuildsResponse.getter(ListBuildsResponse::nextToken)).setter(ListBuildsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> ids;
    private final String nextToken;

    private ListBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.nextToken = builder.nextToken;
    }

    public List<String> ids() {
        return this.ids;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ids());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsResponse)) {
            return false;
        }
        ListBuildsResponse other = (ListBuildsResponse)((Object)obj);
        return Objects.equals(this.ids(), other.ids()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListBuildsResponse").add("Ids", this.ids()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ids": {
                return Optional.ofNullable(clazz.cast(this.ids()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuildsResponse, T> g) {
        return obj -> g.apply((ListBuildsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsResponse model) {
            super(model);
            this.ids(model.ids);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBuildsResponse build() {
            return new ListBuildsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBuildsResponse> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder nextToken(String var1);
    }
}

