/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;

public class BuildArtifactsUnmarshaller
implements Unmarshaller<BuildArtifacts, JsonUnmarshallerContext> {
    private static final BuildArtifactsUnmarshaller INSTANCE = new BuildArtifactsUnmarshaller();

    public BuildArtifacts unmarshall(JsonUnmarshallerContext context) throws Exception {
        BuildArtifacts.Builder buildArtifactsBuilder = BuildArtifacts.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    buildArtifactsBuilder.location((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sha256sum", targetDepth)) {
                    context.nextToken();
                    buildArtifactsBuilder.sha256sum((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("md5sum", targetDepth)) {
                    context.nextToken();
                    buildArtifactsBuilder.md5sum((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BuildArtifacts)buildArtifactsBuilder.build();
    }

    public static BuildArtifactsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

