/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartBuildRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, StartBuildRequest> {
    private final String projectName;
    private final String sourceVersion;
    private final ProjectArtifacts artifactsOverride;
    private final List<EnvironmentVariable> environmentVariablesOverride;
    private final String buildspecOverride;
    private final Integer timeoutInMinutesOverride;

    private StartBuildRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.sourceVersion = builder.sourceVersion;
        this.artifactsOverride = builder.artifactsOverride;
        this.environmentVariablesOverride = builder.environmentVariablesOverride;
        this.buildspecOverride = builder.buildspecOverride;
        this.timeoutInMinutesOverride = builder.timeoutInMinutesOverride;
    }

    public String projectName() {
        return this.projectName;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public ProjectArtifacts artifactsOverride() {
        return this.artifactsOverride;
    }

    public List<EnvironmentVariable> environmentVariablesOverride() {
        return this.environmentVariablesOverride;
    }

    public String buildspecOverride() {
        return this.buildspecOverride;
    }

    public Integer timeoutInMinutesOverride() {
        return this.timeoutInMinutesOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentVariablesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildspecOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutesOverride());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBuildRequest)) {
            return false;
        }
        StartBuildRequest other = (StartBuildRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.artifactsOverride(), other.artifactsOverride()) && Objects.equals(this.environmentVariablesOverride(), other.environmentVariablesOverride()) && Objects.equals(this.buildspecOverride(), other.buildspecOverride()) && Objects.equals(this.timeoutInMinutesOverride(), other.timeoutInMinutesOverride());
    }

    public String toString() {
        return ToString.builder((String)"StartBuildRequest").add("ProjectName", (Object)this.projectName()).add("SourceVersion", (Object)this.sourceVersion()).add("ArtifactsOverride", (Object)this.artifactsOverride()).add("EnvironmentVariablesOverride", this.environmentVariablesOverride()).add("BuildspecOverride", (Object)this.buildspecOverride()).add("TimeoutInMinutesOverride", (Object)this.timeoutInMinutesOverride()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.of(clazz.cast(this.projectName()));
            }
            case "sourceVersion": {
                return Optional.of(clazz.cast(this.sourceVersion()));
            }
            case "artifactsOverride": {
                return Optional.of(clazz.cast(this.artifactsOverride()));
            }
            case "environmentVariablesOverride": {
                return Optional.of(clazz.cast(this.environmentVariablesOverride()));
            }
            case "buildspecOverride": {
                return Optional.of(clazz.cast(this.buildspecOverride()));
            }
            case "timeoutInMinutesOverride": {
                return Optional.of(clazz.cast(this.timeoutInMinutesOverride()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private String sourceVersion;
        private ProjectArtifacts artifactsOverride;
        private List<EnvironmentVariable> environmentVariablesOverride;
        private String buildspecOverride;
        private Integer timeoutInMinutesOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBuildRequest model) {
            this.projectName(model.projectName);
            this.sourceVersion(model.sourceVersion);
            this.artifactsOverride(model.artifactsOverride);
            this.environmentVariablesOverride(model.environmentVariablesOverride);
            this.buildspecOverride(model.buildspecOverride);
            this.timeoutInMinutesOverride(model.timeoutInMinutesOverride);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final ProjectArtifacts.Builder getArtifactsOverride() {
            return this.artifactsOverride != null ? this.artifactsOverride.toBuilder() : null;
        }

        @Override
        public final Builder artifactsOverride(ProjectArtifacts artifactsOverride) {
            this.artifactsOverride = artifactsOverride;
            return this;
        }

        public final void setArtifactsOverride(ProjectArtifacts.BuilderImpl artifactsOverride) {
            this.artifactsOverride = artifactsOverride != null ? artifactsOverride.build() : null;
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironmentVariablesOverride() {
            return this.environmentVariablesOverride != null ? (Collection)this.environmentVariablesOverride.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copy(environmentVariablesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(EnvironmentVariable ... environmentVariablesOverride) {
            this.environmentVariablesOverride(Arrays.asList(environmentVariablesOverride));
            return this;
        }

        public final void setEnvironmentVariablesOverride(Collection<EnvironmentVariable.BuilderImpl> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copyFromBuilder(environmentVariablesOverride);
        }

        public final String getBuildspecOverride() {
            return this.buildspecOverride;
        }

        @Override
        public final Builder buildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
            return this;
        }

        public final void setBuildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
        }

        public final Integer getTimeoutInMinutesOverride() {
            return this.timeoutInMinutesOverride;
        }

        @Override
        public final Builder timeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
            return this;
        }

        public final void setTimeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartBuildRequest build() {
            return new StartBuildRequest(this);
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    CopyableBuilder<Builder, StartBuildRequest> {
        public Builder projectName(String var1);

        public Builder sourceVersion(String var1);

        public Builder artifactsOverride(ProjectArtifacts var1);

        default public Builder artifactsOverride(Consumer<ProjectArtifacts.Builder> artifactsOverride) {
            return this.artifactsOverride((ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().apply(artifactsOverride)).build());
        }

        public Builder environmentVariablesOverride(Collection<EnvironmentVariable> var1);

        public Builder environmentVariablesOverride(EnvironmentVariable ... var1);

        public Builder buildspecOverride(String var1);

        public Builder timeoutInMinutesOverride(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

