/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.transform.LogsLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LogsLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, LogsLocation> {
    private final String groupName;
    private final String streamName;
    private final String deepLink;

    private LogsLocation(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.streamName = builder.streamName;
        this.deepLink = builder.deepLink;
    }

    public String groupName() {
        return this.groupName;
    }

    public String streamName() {
        return this.streamName;
    }

    public String deepLink() {
        return this.deepLink;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deepLink());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsLocation)) {
            return false;
        }
        LogsLocation other = (LogsLocation)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.deepLink(), other.deepLink());
    }

    public String toString() {
        return ToString.builder((String)"LogsLocation").add("GroupName", (Object)this.groupName()).add("StreamName", (Object)this.streamName()).add("DeepLink", (Object)this.deepLink()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "streamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "deepLink": {
                return Optional.of(clazz.cast(this.deepLink()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogsLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String streamName;
        private String deepLink;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsLocation model) {
            this.groupName(model.groupName);
            this.streamName(model.streamName);
            this.deepLink(model.deepLink);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getDeepLink() {
            return this.deepLink;
        }

        @Override
        public final Builder deepLink(String deepLink) {
            this.deepLink = deepLink;
            return this;
        }

        public final void setDeepLink(String deepLink) {
            this.deepLink = deepLink;
        }

        public LogsLocation build() {
            return new LogsLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogsLocation> {
        public Builder groupName(String var1);

        public Builder streamName(String var1);

        public Builder deepLink(String var1);
    }
}

