/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.codebuild.model.Build;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.services.codebuild.model.BuildsCopier;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetBuildsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetBuildsResponse> {
    private final List<Build> builds;
    private final List<String> buildsNotFound;

    private BatchGetBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.builds = builder.builds;
        this.buildsNotFound = builder.buildsNotFound;
    }

    public List<Build> builds() {
        return this.builds;
    }

    public List<String> buildsNotFound() {
        return this.buildsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.builds());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildsNotFound());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBuildsResponse)) {
            return false;
        }
        BatchGetBuildsResponse other = (BatchGetBuildsResponse)((Object)obj);
        return Objects.equals(this.builds(), other.builds()) && Objects.equals(this.buildsNotFound(), other.buildsNotFound());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetBuildsResponse").add("Builds", this.builds()).add("BuildsNotFound", this.buildsNotFound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "builds": {
                return Optional.of(clazz.cast(this.builds()));
            }
            case "buildsNotFound": {
                return Optional.of(clazz.cast(this.buildsNotFound()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<Build> builds;
        private List<String> buildsNotFound;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBuildsResponse model) {
            this.builds(model.builds);
            this.buildsNotFound(model.buildsNotFound);
        }

        public final Collection<Build.Builder> getBuilds() {
            return this.builds != null ? (Collection)this.builds.stream().map(Build::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder builds(Collection<Build> builds) {
            this.builds = BuildsCopier.copy(builds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Build ... builds) {
            this.builds(Arrays.asList(builds));
            return this;
        }

        public final void setBuilds(Collection<Build.BuilderImpl> builds) {
            this.builds = BuildsCopier.copyFromBuilder(builds);
        }

        public final Collection<String> getBuildsNotFound() {
            return this.buildsNotFound;
        }

        @Override
        public final Builder buildsNotFound(Collection<String> buildsNotFound) {
            this.buildsNotFound = BuildIdsCopier.copy(buildsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotFound(String ... buildsNotFound) {
            this.buildsNotFound(Arrays.asList(buildsNotFound));
            return this;
        }

        public final void setBuildsNotFound(Collection<String> buildsNotFound) {
            this.buildsNotFound = BuildIdsCopier.copy(buildsNotFound);
        }

        @Override
        public BatchGetBuildsResponse build() {
            return new BatchGetBuildsResponse(this);
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    CopyableBuilder<Builder, BatchGetBuildsResponse> {
        public Builder builds(Collection<Build> var1);

        public Builder builds(Build ... var1);

        public Builder buildsNotFound(Collection<String> var1);

        public Builder buildsNotFound(String ... var1);
    }
}

