/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild;

import java.util.function.Consumer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.codebuild.CodeBuildClientBuilder;
import software.amazon.awssdk.services.codebuild.DefaultCodeBuildClientBuilder;
import software.amazon.awssdk.services.codebuild.model.AccountLimitExceededException;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.CodeBuildException;
import software.amazon.awssdk.services.codebuild.model.CreateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.CreateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.InvalidInputException;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse;
import software.amazon.awssdk.services.codebuild.model.ListProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.OAuthProviderException;
import software.amazon.awssdk.services.codebuild.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.codebuild.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codebuild.model.StartBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface CodeBuildClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "codebuild";

    public static CodeBuildClient create() {
        return (CodeBuildClient)CodeBuildClient.builder().build();
    }

    public static CodeBuildClientBuilder builder() {
        return new DefaultCodeBuildClientBuilder();
    }

    default public BatchDeleteBuildsResponse batchDeleteBuilds(BatchDeleteBuildsRequest batchDeleteBuildsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public BatchDeleteBuildsResponse batchDeleteBuilds(Consumer<BatchDeleteBuildsRequest.Builder> batchDeleteBuildsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.batchDeleteBuilds((BatchDeleteBuildsRequest)((Object)((BatchDeleteBuildsRequest.Builder)BatchDeleteBuildsRequest.builder().apply(batchDeleteBuildsRequest)).build()));
    }

    default public BatchGetBuildsResponse batchGetBuilds(BatchGetBuildsRequest batchGetBuildsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public BatchGetBuildsResponse batchGetBuilds(Consumer<BatchGetBuildsRequest.Builder> batchGetBuildsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.batchGetBuilds((BatchGetBuildsRequest)((Object)((BatchGetBuildsRequest.Builder)BatchGetBuildsRequest.builder().apply(batchGetBuildsRequest)).build()));
    }

    default public BatchGetProjectsResponse batchGetProjects(BatchGetProjectsRequest batchGetProjectsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public BatchGetProjectsResponse batchGetProjects(Consumer<BatchGetProjectsRequest.Builder> batchGetProjectsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.batchGetProjects((BatchGetProjectsRequest)((Object)((BatchGetProjectsRequest.Builder)BatchGetProjectsRequest.builder().apply(batchGetProjectsRequest)).build()));
    }

    default public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InvalidInputException, ResourceAlreadyExistsException, AccountLimitExceededException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) throws InvalidInputException, ResourceAlreadyExistsException, AccountLimitExceededException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.createProject((CreateProjectRequest)((Object)((CreateProjectRequest.Builder)CreateProjectRequest.builder().apply(createProjectRequest)).build()));
    }

    default public CreateWebhookResponse createWebhook(CreateWebhookRequest createWebhookRequest) throws InvalidInputException, OAuthProviderException, ResourceAlreadyExistsException, ResourceNotFoundException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public CreateWebhookResponse createWebhook(Consumer<CreateWebhookRequest.Builder> createWebhookRequest) throws InvalidInputException, OAuthProviderException, ResourceAlreadyExistsException, ResourceNotFoundException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.createWebhook((CreateWebhookRequest)((Object)((CreateWebhookRequest.Builder)CreateWebhookRequest.builder().apply(createWebhookRequest)).build()));
    }

    default public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.deleteProject((DeleteProjectRequest)((Object)((DeleteProjectRequest.Builder)DeleteProjectRequest.builder().apply(deleteProjectRequest)).build()));
    }

    default public DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws InvalidInputException, ResourceNotFoundException, OAuthProviderException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public DeleteWebhookResponse deleteWebhook(Consumer<DeleteWebhookRequest.Builder> deleteWebhookRequest) throws InvalidInputException, ResourceNotFoundException, OAuthProviderException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.deleteWebhook((DeleteWebhookRequest)((Object)((DeleteWebhookRequest.Builder)DeleteWebhookRequest.builder().apply(deleteWebhookRequest)).build()));
    }

    default public ListBuildsResponse listBuilds() throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.listBuilds((ListBuildsRequest)((Object)ListBuildsRequest.builder().build()));
    }

    default public ListBuildsResponse listBuilds(ListBuildsRequest listBuildsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public ListBuildsResponse listBuilds(Consumer<ListBuildsRequest.Builder> listBuildsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.listBuilds((ListBuildsRequest)((Object)((ListBuildsRequest.Builder)ListBuildsRequest.builder().apply(listBuildsRequest)).build()));
    }

    default public ListBuildsForProjectResponse listBuildsForProject(ListBuildsForProjectRequest listBuildsForProjectRequest) throws InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public ListBuildsForProjectResponse listBuildsForProject(Consumer<ListBuildsForProjectRequest.Builder> listBuildsForProjectRequest) throws InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.listBuildsForProject((ListBuildsForProjectRequest)((Object)((ListBuildsForProjectRequest.Builder)ListBuildsForProjectRequest.builder().apply(listBuildsForProjectRequest)).build()));
    }

    default public ListCuratedEnvironmentImagesResponse listCuratedEnvironmentImages() throws SdkServiceException, SdkClientException, CodeBuildException {
        return this.listCuratedEnvironmentImages((ListCuratedEnvironmentImagesRequest)((Object)ListCuratedEnvironmentImagesRequest.builder().build()));
    }

    default public ListCuratedEnvironmentImagesResponse listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest listCuratedEnvironmentImagesRequest) throws SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public ListCuratedEnvironmentImagesResponse listCuratedEnvironmentImages(Consumer<ListCuratedEnvironmentImagesRequest.Builder> listCuratedEnvironmentImagesRequest) throws SdkServiceException, SdkClientException, CodeBuildException {
        return this.listCuratedEnvironmentImages((ListCuratedEnvironmentImagesRequest)((Object)((ListCuratedEnvironmentImagesRequest.Builder)ListCuratedEnvironmentImagesRequest.builder().apply(listCuratedEnvironmentImagesRequest)).build()));
    }

    default public ListProjectsResponse listProjects() throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.listProjects((ListProjectsRequest)((Object)ListProjectsRequest.builder().build()));
    }

    default public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.listProjects((ListProjectsRequest)((Object)((ListProjectsRequest.Builder)ListProjectsRequest.builder().apply(listProjectsRequest)).build()));
    }

    default public StartBuildResponse startBuild(StartBuildRequest startBuildRequest) throws InvalidInputException, ResourceNotFoundException, AccountLimitExceededException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public StartBuildResponse startBuild(Consumer<StartBuildRequest.Builder> startBuildRequest) throws InvalidInputException, ResourceNotFoundException, AccountLimitExceededException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.startBuild((StartBuildRequest)((Object)((StartBuildRequest.Builder)StartBuildRequest.builder().apply(startBuildRequest)).build()));
    }

    default public StopBuildResponse stopBuild(StopBuildRequest stopBuildRequest) throws InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public StopBuildResponse stopBuild(Consumer<StopBuildRequest.Builder> stopBuildRequest) throws InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.stopBuild((StopBuildRequest)((Object)((StopBuildRequest.Builder)StopBuildRequest.builder().apply(stopBuildRequest)).build()));
    }

    default public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public UpdateProjectResponse updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest) throws InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, CodeBuildException {
        return this.updateProject((UpdateProjectRequest)((Object)((UpdateProjectRequest.Builder)UpdateProjectRequest.builder().apply(updateProjectRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

