/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.BuildPhaseType;
import software.amazon.awssdk.services.codebuild.model.PhaseContext;
import software.amazon.awssdk.services.codebuild.model.PhaseContextsCopier;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.codebuild.transform.BuildPhaseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BuildPhase
implements StructuredPojo,
ToCopyableBuilder<Builder, BuildPhase> {
    private final String phaseType;
    private final String phaseStatus;
    private final Instant startTime;
    private final Instant endTime;
    private final Long durationInSeconds;
    private final List<PhaseContext> contexts;

    private BuildPhase(BuilderImpl builder) {
        this.phaseType = builder.phaseType;
        this.phaseStatus = builder.phaseStatus;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.contexts = builder.contexts;
    }

    public BuildPhaseType phaseType() {
        return BuildPhaseType.fromValue(this.phaseType);
    }

    public String phaseTypeString() {
        return this.phaseType;
    }

    public StatusType phaseStatus() {
        return StatusType.fromValue(this.phaseStatus);
    }

    public String phaseStatusString() {
        return this.phaseStatus;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Long durationInSeconds() {
        return this.durationInSeconds;
    }

    public List<PhaseContext> contexts() {
        return this.contexts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phaseTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phaseStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.contexts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildPhase)) {
            return false;
        }
        BuildPhase other = (BuildPhase)obj;
        return Objects.equals(this.phaseTypeString(), other.phaseTypeString()) && Objects.equals(this.phaseStatusString(), other.phaseStatusString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.contexts(), other.contexts());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.phaseTypeString() != null) {
            sb.append("PhaseType: ").append(this.phaseTypeString()).append(",");
        }
        if (this.phaseStatusString() != null) {
            sb.append("PhaseStatus: ").append(this.phaseStatusString()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.durationInSeconds() != null) {
            sb.append("DurationInSeconds: ").append(this.durationInSeconds()).append(",");
        }
        if (this.contexts() != null) {
            sb.append("Contexts: ").append(this.contexts()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "phaseType": {
                return Optional.of(clazz.cast(this.phaseTypeString()));
            }
            case "phaseStatus": {
                return Optional.of(clazz.cast(this.phaseStatusString()));
            }
            case "startTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "durationInSeconds": {
                return Optional.of(clazz.cast(this.durationInSeconds()));
            }
            case "contexts": {
                return Optional.of(clazz.cast(this.contexts()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildPhaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String phaseType;
        private String phaseStatus;
        private Instant startTime;
        private Instant endTime;
        private Long durationInSeconds;
        private List<PhaseContext> contexts;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildPhase model) {
            this.phaseType(model.phaseType);
            this.phaseStatus(model.phaseStatus);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.durationInSeconds(model.durationInSeconds);
            this.contexts(model.contexts);
        }

        public final String getPhaseType() {
            return this.phaseType;
        }

        @Override
        public final Builder phaseType(String phaseType) {
            this.phaseType = phaseType;
            return this;
        }

        @Override
        public final Builder phaseType(BuildPhaseType phaseType) {
            this.phaseType(phaseType.toString());
            return this;
        }

        public final void setPhaseType(String phaseType) {
            this.phaseType = phaseType;
        }

        public final String getPhaseStatus() {
            return this.phaseStatus;
        }

        @Override
        public final Builder phaseStatus(String phaseStatus) {
            this.phaseStatus = phaseStatus;
            return this;
        }

        @Override
        public final Builder phaseStatus(StatusType phaseStatus) {
            this.phaseStatus(phaseStatus.toString());
            return this;
        }

        public final void setPhaseStatus(String phaseStatus) {
            this.phaseStatus = phaseStatus;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Long getDurationInSeconds() {
            return this.durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public final Collection<PhaseContext.Builder> getContexts() {
            return this.contexts != null ? (Collection)this.contexts.stream().map(PhaseContext::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contexts(Collection<PhaseContext> contexts) {
            this.contexts = PhaseContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(PhaseContext ... contexts) {
            this.contexts(Arrays.asList(contexts));
            return this;
        }

        public final void setContexts(Collection<PhaseContext.BuilderImpl> contexts) {
            this.contexts = PhaseContextsCopier.copyFromBuilder(contexts);
        }

        public BuildPhase build() {
            return new BuildPhase(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BuildPhase> {
        public Builder phaseType(String var1);

        public Builder phaseType(BuildPhaseType var1);

        public Builder phaseStatus(String var1);

        public Builder phaseStatus(StatusType var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder durationInSeconds(Long var1);

        public Builder contexts(Collection<PhaseContext> var1);

        public Builder contexts(PhaseContext ... var1);
    }
}

