/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codebuild.model.PhaseContext;

public class PhaseContextUnmarshaller
implements Unmarshaller<PhaseContext, JsonUnmarshallerContext> {
    private static final PhaseContextUnmarshaller INSTANCE = new PhaseContextUnmarshaller();

    public PhaseContext unmarshall(JsonUnmarshallerContext context) throws Exception {
        PhaseContext.Builder phaseContextBuilder = PhaseContext.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("statusCode", targetDepth)) {
                    context.nextToken();
                    phaseContextBuilder.statusCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("message", targetDepth)) {
                    context.nextToken();
                    phaseContextBuilder.message((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PhaseContext)phaseContextBuilder.build();
    }

    public static PhaseContextUnmarshaller getInstance() {
        return INSTANCE;
    }
}

