/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.transform.EnvironmentImageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentImage
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentImage> {
    private final String name;
    private final String description;

    private EnvironmentImage(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentImage)) {
            return false;
        }
        EnvironmentImage other = (EnvironmentImage)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentImage model) {
            this.name(model.name);
            this.description(model.description);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public EnvironmentImage build() {
            return new EnvironmentImage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentImage> {
        public Builder name(String var1);

        public Builder description(String var1);
    }
}

