/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;
import software.amazon.awssdk.services.codebuild.model.BuildPhasesCopier;
import software.amazon.awssdk.services.codebuild.model.LogsLocation;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.codebuild.transform.BuildMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Build
implements StructuredPojo,
ToCopyableBuilder<Builder, Build> {
    private final String id;
    private final String arn;
    private final Instant startTime;
    private final Instant endTime;
    private final String currentPhase;
    private final String buildStatus;
    private final String sourceVersion;
    private final String projectName;
    private final List<BuildPhase> phases;
    private final ProjectSource source;
    private final BuildArtifacts artifacts;
    private final ProjectEnvironment environment;
    private final LogsLocation logs;
    private final Integer timeoutInMinutes;
    private final Boolean buildComplete;
    private final String initiator;

    private Build(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.currentPhase = builder.currentPhase;
        this.buildStatus = builder.buildStatus;
        this.sourceVersion = builder.sourceVersion;
        this.projectName = builder.projectName;
        this.phases = builder.phases;
        this.source = builder.source;
        this.artifacts = builder.artifacts;
        this.environment = builder.environment;
        this.logs = builder.logs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.buildComplete = builder.buildComplete;
        this.initiator = builder.initiator;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String currentPhase() {
        return this.currentPhase;
    }

    public StatusType buildStatus() {
        return StatusType.fromValue(this.buildStatus);
    }

    public String buildStatusString() {
        return this.buildStatus;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public String projectName() {
        return this.projectName;
    }

    public List<BuildPhase> phases() {
        return this.phases;
    }

    public ProjectSource source() {
        return this.source;
    }

    public BuildArtifacts artifacts() {
        return this.artifacts;
    }

    public ProjectEnvironment environment() {
        return this.environment;
    }

    public LogsLocation logs() {
        return this.logs;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Boolean buildComplete() {
        return this.buildComplete;
    }

    public String initiator() {
        return this.initiator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.currentPhase() == null ? 0 : this.currentPhase().hashCode());
        hashCode = 31 * hashCode + (this.buildStatusString() == null ? 0 : this.buildStatusString().hashCode());
        hashCode = 31 * hashCode + (this.sourceVersion() == null ? 0 : this.sourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.projectName() == null ? 0 : this.projectName().hashCode());
        hashCode = 31 * hashCode + (this.phases() == null ? 0 : this.phases().hashCode());
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.artifacts() == null ? 0 : this.artifacts().hashCode());
        hashCode = 31 * hashCode + (this.environment() == null ? 0 : this.environment().hashCode());
        hashCode = 31 * hashCode + (this.logs() == null ? 0 : this.logs().hashCode());
        hashCode = 31 * hashCode + (this.timeoutInMinutes() == null ? 0 : this.timeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.buildComplete() == null ? 0 : this.buildComplete().hashCode());
        hashCode = 31 * hashCode + (this.initiator() == null ? 0 : this.initiator().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.currentPhase() == null ^ this.currentPhase() == null) {
            return false;
        }
        if (other.currentPhase() != null && !other.currentPhase().equals(this.currentPhase())) {
            return false;
        }
        if (other.buildStatusString() == null ^ this.buildStatusString() == null) {
            return false;
        }
        if (other.buildStatusString() != null && !other.buildStatusString().equals(this.buildStatusString())) {
            return false;
        }
        if (other.sourceVersion() == null ^ this.sourceVersion() == null) {
            return false;
        }
        if (other.sourceVersion() != null && !other.sourceVersion().equals(this.sourceVersion())) {
            return false;
        }
        if (other.projectName() == null ^ this.projectName() == null) {
            return false;
        }
        if (other.projectName() != null && !other.projectName().equals(this.projectName())) {
            return false;
        }
        if (other.phases() == null ^ this.phases() == null) {
            return false;
        }
        if (other.phases() != null && !other.phases().equals(this.phases())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.artifacts() == null ^ this.artifacts() == null) {
            return false;
        }
        if (other.artifacts() != null && !other.artifacts().equals(this.artifacts())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        if (other.logs() == null ^ this.logs() == null) {
            return false;
        }
        if (other.logs() != null && !other.logs().equals(this.logs())) {
            return false;
        }
        if (other.timeoutInMinutes() == null ^ this.timeoutInMinutes() == null) {
            return false;
        }
        if (other.timeoutInMinutes() != null && !other.timeoutInMinutes().equals(this.timeoutInMinutes())) {
            return false;
        }
        if (other.buildComplete() == null ^ this.buildComplete() == null) {
            return false;
        }
        if (other.buildComplete() != null && !other.buildComplete().equals(this.buildComplete())) {
            return false;
        }
        if (other.initiator() == null ^ this.initiator() == null) {
            return false;
        }
        return other.initiator() == null || other.initiator().equals(this.initiator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.currentPhase() != null) {
            sb.append("CurrentPhase: ").append(this.currentPhase()).append(",");
        }
        if (this.buildStatusString() != null) {
            sb.append("BuildStatus: ").append(this.buildStatusString()).append(",");
        }
        if (this.sourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.sourceVersion()).append(",");
        }
        if (this.projectName() != null) {
            sb.append("ProjectName: ").append(this.projectName()).append(",");
        }
        if (this.phases() != null) {
            sb.append("Phases: ").append(this.phases()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.artifacts() != null) {
            sb.append("Artifacts: ").append(this.artifacts()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.logs() != null) {
            sb.append("Logs: ").append(this.logs()).append(",");
        }
        if (this.timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.timeoutInMinutes()).append(",");
        }
        if (this.buildComplete() != null) {
            sb.append("BuildComplete: ").append(this.buildComplete()).append(",");
        }
        if (this.initiator() != null) {
            sb.append("Initiator: ").append(this.initiator()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "startTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "currentPhase": {
                return Optional.of(clazz.cast(this.currentPhase()));
            }
            case "buildStatus": {
                return Optional.of(clazz.cast(this.buildStatusString()));
            }
            case "sourceVersion": {
                return Optional.of(clazz.cast(this.sourceVersion()));
            }
            case "projectName": {
                return Optional.of(clazz.cast(this.projectName()));
            }
            case "phases": {
                return Optional.of(clazz.cast(this.phases()));
            }
            case "source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "artifacts": {
                return Optional.of(clazz.cast(this.artifacts()));
            }
            case "environment": {
                return Optional.of(clazz.cast(this.environment()));
            }
            case "logs": {
                return Optional.of(clazz.cast(this.logs()));
            }
            case "timeoutInMinutes": {
                return Optional.of(clazz.cast(this.timeoutInMinutes()));
            }
            case "buildComplete": {
                return Optional.of(clazz.cast(this.buildComplete()));
            }
            case "initiator": {
                return Optional.of(clazz.cast(this.initiator()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private Instant startTime;
        private Instant endTime;
        private String currentPhase;
        private String buildStatus;
        private String sourceVersion;
        private String projectName;
        private List<BuildPhase> phases;
        private ProjectSource source;
        private BuildArtifacts artifacts;
        private ProjectEnvironment environment;
        private LogsLocation logs;
        private Integer timeoutInMinutes;
        private Boolean buildComplete;
        private String initiator;

        private BuilderImpl() {
        }

        private BuilderImpl(Build model) {
            this.id(model.id);
            this.arn(model.arn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.currentPhase(model.currentPhase);
            this.buildStatus(model.buildStatus);
            this.sourceVersion(model.sourceVersion);
            this.projectName(model.projectName);
            this.phases(model.phases);
            this.source(model.source);
            this.artifacts(model.artifacts);
            this.environment(model.environment);
            this.logs(model.logs);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.buildComplete(model.buildComplete);
            this.initiator(model.initiator);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getCurrentPhase() {
            return this.currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(StatusType buildStatus) {
            this.buildStatus(buildStatus.toString());
            return this;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Collection<BuildPhase.Builder> getPhases() {
            return this.phases != null ? (Collection)this.phases.stream().map(BuildPhase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phases(Collection<BuildPhase> phases) {
            this.phases = BuildPhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(BuildPhase ... phases) {
            this.phases(Arrays.asList(phases));
            return this;
        }

        public final void setPhases(Collection<BuildPhase.BuilderImpl> phases) {
            this.phases = BuildPhasesCopier.copyFromBuilder(phases);
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final BuildArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        @Override
        public final Builder artifacts(BuildArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final void setArtifacts(BuildArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final LogsLocation.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(LogsLocation.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Boolean getBuildComplete() {
            return this.buildComplete;
        }

        @Override
        public final Builder buildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
            return this;
        }

        public final void setBuildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
        }

        public final String getInitiator() {
            return this.initiator;
        }

        @Override
        public final Builder initiator(String initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(String initiator) {
            this.initiator = initiator;
        }

        public Build build() {
            return new Build(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Build> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder currentPhase(String var1);

        public Builder buildStatus(String var1);

        public Builder buildStatus(StatusType var1);

        public Builder sourceVersion(String var1);

        public Builder projectName(String var1);

        public Builder phases(Collection<BuildPhase> var1);

        public Builder phases(BuildPhase ... var1);

        public Builder source(ProjectSource var1);

        public Builder artifacts(BuildArtifacts var1);

        public Builder environment(ProjectEnvironment var1);

        public Builder logs(LogsLocation var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder buildComplete(Boolean var1);

        public Builder initiator(String var1);
    }
}

