/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;
import software.amazon.awssdk.services.codebuild.transform.PhaseContextUnmarshaller;

public class BuildPhaseUnmarshaller
implements Unmarshaller<BuildPhase, JsonUnmarshallerContext> {
    private static final BuildPhaseUnmarshaller INSTANCE = new BuildPhaseUnmarshaller();

    public BuildPhase unmarshall(JsonUnmarshallerContext context) throws Exception {
        BuildPhase.Builder buildPhaseBuilder = BuildPhase.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("phaseType", targetDepth)) {
                    context.nextToken();
                    buildPhaseBuilder.phaseType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("phaseStatus", targetDepth)) {
                    context.nextToken();
                    buildPhaseBuilder.phaseStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("startTime", targetDepth)) {
                    context.nextToken();
                    buildPhaseBuilder.startTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("endTime", targetDepth)) {
                    context.nextToken();
                    buildPhaseBuilder.endTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("durationInSeconds", targetDepth)) {
                    context.nextToken();
                    buildPhaseBuilder.durationInSeconds((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("contexts", targetDepth)) {
                    context.nextToken();
                    buildPhaseBuilder.contexts(new ListUnmarshaller((Unmarshaller)PhaseContextUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BuildPhase)buildPhaseBuilder.build();
    }

    public static BuildPhaseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

