/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform;
import software.amazon.awssdk.services.codebuild.model.EnvironmentPlatformsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCuratedEnvironmentImagesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCuratedEnvironmentImagesResponse> {
    private final List<EnvironmentPlatform> platforms;

    private ListCuratedEnvironmentImagesResponse(BuilderImpl builder) {
        this.platforms = builder.platforms;
    }

    public List<EnvironmentPlatform> platforms() {
        return this.platforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platforms() == null ? 0 : this.platforms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCuratedEnvironmentImagesResponse)) {
            return false;
        }
        ListCuratedEnvironmentImagesResponse other = (ListCuratedEnvironmentImagesResponse)((Object)obj);
        if (other.platforms() == null ^ this.platforms() == null) {
            return false;
        }
        return other.platforms() == null || other.platforms().equals(this.platforms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.platforms() != null) {
            sb.append("Platforms: ").append(this.platforms()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EnvironmentPlatform> platforms;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCuratedEnvironmentImagesResponse model) {
            this.setPlatforms(model.platforms);
        }

        public final Collection<EnvironmentPlatform> getPlatforms() {
            return this.platforms;
        }

        @Override
        public final Builder platforms(Collection<EnvironmentPlatform> platforms) {
            this.platforms = EnvironmentPlatformsCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(EnvironmentPlatform ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        public final void setPlatforms(Collection<EnvironmentPlatform> platforms) {
            this.platforms = EnvironmentPlatformsCopier.copy(platforms);
        }

        @SafeVarargs
        public final void setPlatforms(EnvironmentPlatform ... platforms) {
            this.platforms(Arrays.asList(platforms));
        }

        public ListCuratedEnvironmentImagesResponse build() {
            return new ListCuratedEnvironmentImagesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCuratedEnvironmentImagesResponse> {
        public Builder platforms(Collection<EnvironmentPlatform> var1);

        public Builder platforms(EnvironmentPlatform ... var1);
    }
}

