/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.EnvironmentImage;
import software.amazon.awssdk.services.codebuild.model.EnvironmentImagesCopier;
import software.amazon.awssdk.services.codebuild.model.LanguageType;
import software.amazon.awssdk.services.codebuild.transform.EnvironmentLanguageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentLanguage
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentLanguage> {
    private final String language;
    private final List<EnvironmentImage> images;

    private EnvironmentLanguage(BuilderImpl builder) {
        this.language = builder.language;
        this.images = builder.images;
    }

    public String language() {
        return this.language;
    }

    public List<EnvironmentImage> images() {
        return this.images;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.language() == null ? 0 : this.language().hashCode());
        hashCode = 31 * hashCode + (this.images() == null ? 0 : this.images().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLanguage)) {
            return false;
        }
        EnvironmentLanguage other = (EnvironmentLanguage)obj;
        if (other.language() == null ^ this.language() == null) {
            return false;
        }
        if (other.language() != null && !other.language().equals(this.language())) {
            return false;
        }
        if (other.images() == null ^ this.images() == null) {
            return false;
        }
        return other.images() == null || other.images().equals(this.images());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.language() != null) {
            sb.append("Language: ").append(this.language()).append(",");
        }
        if (this.images() != null) {
            sb.append("Images: ").append(this.images()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentLanguageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String language;
        private List<EnvironmentImage> images;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentLanguage model) {
            this.setLanguage(model.language);
            this.setImages(model.images);
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(LanguageType language) {
            this.language(language.toString());
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final void setLanguage(LanguageType language) {
            this.language(language.toString());
        }

        public final Collection<EnvironmentImage> getImages() {
            return this.images;
        }

        @Override
        public final Builder images(Collection<EnvironmentImage> images) {
            this.images = EnvironmentImagesCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(EnvironmentImage ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        public final void setImages(Collection<EnvironmentImage> images) {
            this.images = EnvironmentImagesCopier.copy(images);
        }

        @SafeVarargs
        public final void setImages(EnvironmentImage ... images) {
            this.images(Arrays.asList(images));
        }

        public EnvironmentLanguage build() {
            return new EnvironmentLanguage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentLanguage> {
        public Builder language(String var1);

        public Builder language(LanguageType var1);

        public Builder images(Collection<EnvironmentImage> var1);

        public Builder images(EnvironmentImage ... var1);
    }
}

